/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.model;

import com.anahata.util.model.Activatable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.lang3.Validate;

public final class ActivePredicate
implements Predicate {
    public static ActivePredicate INSTANCE = new ActivePredicate();

    public boolean evaluate(Object object) {
        boolean satisfies = false;
        if (object instanceof Activatable) {
            Activatable activatable = (Activatable)object;
            satisfies = activatable.isActive();
        }
        return satisfies;
    }

    public static <T extends Activatable> Iterator<T> iterator(Collection<T> coll) {
        if (coll == null) {
            return Collections.emptyIterator();
        }
        return new FilterIterator(coll.iterator(), (Predicate)INSTANCE);
    }

    public static <T extends Activatable> T singleItem(Collection<T> coll) {
        Iterator<T> it = ActivePredicate.iterator(coll);
        if (!it.hasNext()) {
            return null;
        }
        Activatable result = (Activatable)it.next();
        Validate.isTrue((!it.hasNext() ? 1 : 0) != 0, (String)"The collection had more than one element: %s", (Object[])new Object[]{coll});
        return (T)result;
    }

    public static <T extends Activatable> List<T> list(Collection<T> coll) {
        ArrayList<T> result = new ArrayList<T>();
        Iterator<T> it = ActivePredicate.iterator(coll);
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static <T extends Activatable> List<T> removeInactive(Collection<T> coll) {
        ArrayList<Activatable> result = new ArrayList<Activatable>();
        Iterator<T> it = ActivePredicate.iterator(coll);
        while (it.hasNext()) {
            Activatable t = (Activatable)it.next();
            if (t.isActive()) continue;
            it.remove();
            result.add(t);
        }
        return result;
    }

    private ActivePredicate() {
    }
}

