/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.lang;

import java.util.concurrent.ThreadFactory;

public final class BasicThreadFactory
implements ThreadFactory {
    private final String name;
    private final boolean daemon;
    private final int priority;
    private volatile int count = 0;

    public BasicThreadFactory(String name, boolean daemon, int priority) {
        this.name = name;
        this.daemon = daemon;
        this.priority = priority;
    }

    public BasicThreadFactory(String name) {
        this(name, true, 5);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r);
        t.setName(this.name + "-" + this.count++);
        t.setDaemon(this.daemon);
        return t;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getCount() {
        return this.count;
    }
}

