/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.text.highlight;

import com.anahata.util.lang.StringLengthComparator;
import com.anahata.util.search.AnahataSearchUtils;
import com.anahata.util.text.highlight.TextMatchToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HighlightUtils {
    private static final Logger log = LoggerFactory.getLogger(HighlightUtils.class);

    public static List<TextMatchToken> textMatchTokens(String text, String ... criteriaTokens) {
        ArrayList<TextMatchToken> ret = new ArrayList<TextMatchToken>();
        Arrays.sort(criteriaTokens, StringLengthComparator.INSTANCE);
        ret.add(new TextMatchToken(text, false));
        for (int i = 0; i < criteriaTokens.length; ++i) {
            String criteriaToken = criteriaTokens[i];
            if (criteriaToken.isEmpty()) continue;
            int j = 0;
            while (j < ret.size()) {
                TextMatchToken currentToken = (TextMatchToken)ret.get(j);
                if (!currentToken.isMatching()) {
                    List<TextMatchToken> l = HighlightUtils.split(currentToken.getString(), criteriaToken);
                    if (l.size() > 1 || l.iterator().next().isMatching()) {
                        ret.remove(j);
                        ret.addAll(j, l);
                        j += l.size();
                        continue;
                    }
                    ++j;
                    continue;
                }
                ++j;
            }
        }
        return ret;
    }

    private static List<TextMatchToken> split(String source, String criteria) {
        String suffix;
        assert (source != null);
        assert (criteria != null);
        ArrayList<TextMatchToken> ret = new ArrayList<TextMatchToken>();
        if (source.isEmpty()) {
            ret.add(new TextMatchToken(source, false));
            return ret;
        }
        Pattern pattern = AnahataSearchUtils.makeTokenMatchPattern(criteria);
        Matcher m = pattern.matcher(source);
        int start = 0;
        while (m.find()) {
            String preffix = source.substring(start, m.start());
            String token = m.group();
            start = m.end();
            if (!preffix.isEmpty()) {
                ret.add(new TextMatchToken(preffix, false));
            }
            if (token.isEmpty()) continue;
            ret.add(new TextMatchToken(token, true));
        }
        if (start < source.length() && !(suffix = source.substring(start)).isEmpty()) {
            ret.add(new TextMatchToken(suffix, false));
        }
        return ret;
    }

    private HighlightUtils() {
    }
}

