/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.redundant;

import com.anahata.util.progress.ProgressListener;
import com.anahata.util.redundant.RedundantTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallellTask<T>
extends RedundantTask<T> {
    private static final Logger log = LoggerFactory.getLogger(ParallellTask.class);

    public ParallellTask(ExecutorService executorService) {
        super(executorService);
    }

    public ParallellTask(ExecutorService executorService, ProgressListener pl) {
        super(executorService, pl);
    }

    @Override
    public synchronized void execute() {
        for (Callable callable : this.getCallables()) {
            log.debug("submitting : {}", callable);
            this.submit(new CallableMonitor(callable));
        }
    }

    protected class CallableMonitor
    implements Runnable {
        private final Callable<T> callable;

        public CallableMonitor(Callable<T> callable) {
            this.callable = callable;
        }

        @Override
        public void run() {
            block3: {
                if (!ParallellTask.this.isRunning()) {
                    return;
                }
                log.debug("Wrapper.run, thread {} registered ", (Object)Thread.currentThread());
                try {
                    Object ret = this.callable.call();
                    ParallellTask.this.suceeded(ret);
                }
                catch (Throwable e) {
                    ParallellTask.this.registerError(e);
                    if (ParallellTask.this.getErrors().size() != ParallellTask.this.getCallables().size()) break block3;
                    ParallellTask.this.fail();
                }
            }
        }
    }
}

