/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.lang.builder;

import lombok.NonNull;

public final class DelimitedStringBuilder {
    private final StringBuilder sb;
    private final String delimiter;
    boolean first;

    public DelimitedStringBuilder(@NonNull String delimiter) {
        if (delimiter == null) {
            throw new NullPointerException("delimiter");
        }
        this.sb = new StringBuilder();
        this.delimiter = delimiter;
        this.first = true;
    }

    public DelimitedStringBuilder append(Object obj) {
        this.appendDelimiter();
        this.sb.append(obj);
        return this;
    }

    public DelimitedStringBuilder append(String str) {
        this.appendDelimiter();
        this.sb.append(str);
        return this;
    }

    public DelimitedStringBuilder append(StringBuffer sb) {
        this.appendDelimiter();
        this.sb.append(sb);
        return this;
    }

    public DelimitedStringBuilder append(CharSequence s) {
        this.appendDelimiter();
        this.sb.append(s);
        return this;
    }

    public DelimitedStringBuilder append(CharSequence s, int start, int end) {
        this.appendDelimiter();
        this.sb.append(s, start, end);
        return this;
    }

    public DelimitedStringBuilder append(char[] str) {
        this.appendDelimiter();
        this.sb.append(str);
        return this;
    }

    public DelimitedStringBuilder append(char[] str, int offset, int len) {
        this.appendDelimiter();
        this.sb.append(str, offset, len);
        return this;
    }

    public DelimitedStringBuilder append(boolean b) {
        this.appendDelimiter();
        this.sb.append(b);
        return this;
    }

    public DelimitedStringBuilder append(char c) {
        this.appendDelimiter();
        this.sb.append(c);
        return this;
    }

    public DelimitedStringBuilder append(int i) {
        this.appendDelimiter();
        this.sb.append(i);
        return this;
    }

    public DelimitedStringBuilder append(long lng) {
        this.appendDelimiter();
        this.sb.append(lng);
        return this;
    }

    public DelimitedStringBuilder append(float f) {
        this.appendDelimiter();
        this.sb.append(f);
        return this;
    }

    public DelimitedStringBuilder append(double d) {
        this.appendDelimiter();
        this.sb.append(d);
        return this;
    }

    public String toString() {
        return this.sb.toString();
    }

    private void appendDelimiter() {
        if (this.first) {
            this.first = false;
        } else {
            this.sb.append(this.delimiter);
        }
    }
}

