/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.props;

import com.anahata.util.env.ApplicationEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertiesUtils {
    private static final Logger log = LoggerFactory.getLogger(PropertiesUtils.class);
    private static final String APP_PROPS = "/application.properties";

    public static void load(Properties props, String propFileName) {
        Validate.notNull((Object)props);
        Validate.notNull((Object)propFileName);
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(propFileName);
        if (is == null) {
            is = PropertiesUtils.class.getResourceAsStream(propFileName);
        }
        Validate.isTrue((is != null ? 1 : 0) != 0, (String)"Could not load properties file: %s", (Object[])new Object[]{propFileName});
        try {
            props.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading properties file: " + propFileName, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.error("There was an error closing the properties file input stream for properties file: " + propFileName, (Throwable)e);
                }
            }
        }
    }

    public static void loadAppProps(Properties props, ApplicationEnvironment env) {
        Validate.notNull((Object)props);
        Validate.notNull((Object)((Object)env));
        log.debug("Loading properties from file {}", (Object)APP_PROPS);
        PropertiesUtils.load(props, APP_PROPS);
        String propsFile = "/application-" + env.toString().toLowerCase() + ".properties";
        log.debug("Loading properties from file {}", (Object)propsFile);
        try {
            PropertiesUtils.load(props, propsFile);
        }
        catch (IllegalArgumentException e) {
            log.info("No environment specific property file found for: {}", (Object)propsFile);
        }
        if (env == ApplicationEnvironment.LOCAL) {
            String osUserName = System.getProperty("user.name");
            String osUserPropsFile = "/application-" + env.toString().toLowerCase() + "-" + osUserName + ".properties";
            log.debug("Loading properties from file {}", (Object)osUserPropsFile);
            try {
                PropertiesUtils.load(props, osUserPropsFile);
            }
            catch (IllegalArgumentException e) {
                log.info("No os user environment specific property file found for: {}", (Object)osUserPropsFile);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Final properties:");
            TreeMap<String, String> propMap = new TreeMap<String, String>();
            for (String propName : props.stringPropertyNames()) {
                String propValue = props.getProperty(propName);
                propMap.put(propName, propValue);
            }
            for (String propName : propMap.keySet()) {
                log.debug("{} = {}", (Object)propName, propMap.get(propName));
            }
        }
    }

    public static void setSystemProperties(Properties props, String prefix) {
        Validate.notNull((Object)props);
        Validate.notNull((Object)prefix);
        prefix = prefix + ".";
        int start = prefix.length();
        for (String prop : props.stringPropertyNames()) {
            if (!prop.startsWith(prefix)) continue;
            String name = prop.substring(start);
            String value = props.getProperty(prop);
            log.debug("Setting system property name={} value={}", (Object)name, (Object)value);
            System.getProperties().setProperty(name, value);
        }
    }

    public static void setSystemProperties(Properties props) {
        PropertiesUtils.setSystemProperties(props, "sysprop");
    }

    private PropertiesUtils() {
    }
}

