/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.lang;

import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public final class StringBuilderUtils {
    public static void append(@NonNull StringBuilder sb, @NonNull String prefix, @NonNull String separator, String ... values) {
        if (sb == null) {
            throw new NullPointerException("sb");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix");
        }
        if (separator == null) {
            throw new NullPointerException("separator");
        }
        if (values != null) {
            boolean first = true;
            for (String value : values) {
                if (value == null) continue;
                if (sb.length() > 0) {
                    if (first) {
                        sb.append(prefix);
                        first = false;
                    } else {
                        sb.append(separator);
                    }
                }
                sb.append(value);
            }
        }
    }

    public static void appendNotBlank(@NonNull StringBuilder sb, @NonNull String prefix, @NonNull String separator, String ... values) {
        if (sb == null) {
            throw new NullPointerException("sb");
        }
        if (prefix == null) {
            throw new NullPointerException("prefix");
        }
        if (separator == null) {
            throw new NullPointerException("separator");
        }
        if (values != null) {
            boolean first = true;
            for (String value : values) {
                if (!StringUtils.isNotBlank((CharSequence)value)) continue;
                if (sb.length() > 0) {
                    if (first) {
                        sb.append(prefix);
                        first = false;
                    } else {
                        sb.append(separator);
                    }
                }
                sb.append(value);
            }
        }
    }

    private StringBuilderUtils() {
    }
}

