/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.logging;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteServiceWarning
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(RemoteServiceWarning.class);
    private Method method;
    private Object[] args;
    private Object ret;
    private long time;
    private long argsSize;
    private long retSize;
    private Reason reason;

    public static RemoteServiceWarning newSlow(Method method, Object[] args, long argsSize, Object ret, long retSize, long time) {
        RemoteServiceWarning warning = new RemoteServiceWarning();
        warning.method = method;
        warning.args = args;
        warning.argsSize = argsSize;
        warning.ret = ret;
        warning.retSize = retSize;
        warning.time = time;
        warning.reason = Reason.SLOW;
        return warning;
    }

    public static RemoteServiceWarning newArgsLarge(Method method, Object[] args, long argsSize) {
        RemoteServiceWarning warning = new RemoteServiceWarning();
        warning.method = method;
        warning.args = args;
        warning.argsSize = argsSize;
        warning.reason = Reason.ARGS_LARGE;
        return warning;
    }

    public static RemoteServiceWarning newRetLarge(Method method, Object ret, long retSize) {
        RemoteServiceWarning warning = new RemoteServiceWarning();
        warning.method = method;
        warning.retSize = retSize;
        warning.reason = Reason.RET_LARGE;
        return warning;
    }

    public void logWarn() {
        log.warn("SLOW SLOW SLOW!!! " + this.toString());
    }

    public String toString() {
        return "RemoteServiceWarning{method=" + this.method + ", args=" + this.args + ", ret=" + this.ret + ", time=" + this.time + ", argsSize=" + this.argsSize + ", retSize=" + this.retSize + ", reason=" + (Object)((Object)this.reason) + '}';
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Object getRet() {
        return this.ret;
    }

    public long getTime() {
        return this.time;
    }

    public long getArgsSize() {
        return this.argsSize;
    }

    public long getRetSize() {
        return this.retSize;
    }

    public Reason getReason() {
        return this.reason;
    }

    private RemoteServiceWarning() {
    }

    public static enum Reason {
        SLOW,
        ARGS_LARGE,
        RET_LARGE;

    }
}

