/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.email;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.StringUtils;

public final class EmailUtils {
    private static final List<Character> EMAIL_ADDRESS_ADDITIONAL_VALID_CHARS = Collections.unmodifiableList(Arrays.asList(Character.valueOf('@'), Character.valueOf('!'), Character.valueOf('#'), Character.valueOf('$'), Character.valueOf('%'), Character.valueOf('&'), Character.valueOf('\''), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('-'), Character.valueOf('/'), Character.valueOf('='), Character.valueOf('?'), Character.valueOf('^'), Character.valueOf('_'), Character.valueOf('`'), Character.valueOf('{'), Character.valueOf('|'), Character.valueOf('}'), Character.valueOf('~'), Character.valueOf('.')));

    public static boolean isValidEmailAddressChar(char c) {
        return Character.isLetterOrDigit(c) || EMAIL_ADDRESS_ADDITIONAL_VALID_CHARS.contains(Character.valueOf(c));
    }

    public static List<String> parseEmailAddresses(String text) {
        ArrayList<String> emails = new ArrayList<String>();
        if (text != null) {
            Pattern pattern = Pattern.compile("([_A-Za-z0-9-]+)(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9-]+)*(\\.[A-Za-z]{2,})");
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                emails.add(matcher.group());
            }
        }
        return emails;
    }

    public static boolean isValidEmailAddress(String email) {
        try {
            new InternetAddress(email).validate();
        }
        catch (AddressException ex) {
            return false;
        }
        return true;
    }

    public static boolean isValidEmailAddresses(String email) {
        try {
            InternetAddress[] ia;
            for (InternetAddress ia1 : ia = InternetAddress.parse((String)email, (boolean)false)) {
                ia1.validate();
            }
        }
        catch (AddressException ex) {
            return false;
        }
        return true;
    }

    public static String[] parseAddresses(String s) throws AddressException {
        if (!StringUtils.isBlank((CharSequence)s)) {
            InternetAddress[] ia = InternetAddress.parse((String)s);
            String[] ret = new String[ia.length];
            for (int i = 0; i < ia.length; ++i) {
                ret[i] = ia[i].toUnicodeString();
            }
            return ret;
        }
        return new String[0];
    }

    public static String[] parseAddressesOnly(String s) throws AddressException {
        if (!StringUtils.isBlank((CharSequence)s)) {
            InternetAddress[] ia = InternetAddress.parse((String)s);
            String[] ret = new String[ia.length];
            for (int i = 0; i < ia.length; ++i) {
                ret[i] = ia[i].getAddress();
            }
            return ret;
        }
        return new String[0];
    }

    private EmailUtils() {
    }
}

