/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.config;

import com.anahata.util.props.StructuredProperties;
import java.util.Properties;
import org.apache.commons.lang3.Validate;

public class OutgoingEmailConfig {
    private String host;
    private int port;
    private boolean ssl;
    private String user;
    private String password;
    private String subject;
    private String from;
    private String to;
    private String cc;
    private String bcc;
    private boolean imagesEnabled;
    private boolean bccSender;

    public OutgoingEmailConfig(Properties props, String ... prefixes) {
        Validate.notNull((Object)props);
        StructuredProperties sprops = new StructuredProperties(props, prefixes);
        this.host = sprops.getString("host");
        this.port = sprops.getInteger("port", 25);
        this.ssl = sprops.getBoolean("ssl", false);
        this.user = sprops.getString("user", null);
        this.password = sprops.getString("password", null);
        this.from = sprops.getString("from", null);
        this.to = sprops.getString("to", null);
        this.cc = sprops.getString("cc", null);
        this.bcc = sprops.getString("bcc", null);
        this.subject = sprops.getString("subject");
        this.imagesEnabled = sprops.getBoolean("images.enabled", true);
        this.bccSender = sprops.getBoolean("bcc.sender", true);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTo() {
        return this.to;
    }

    public String getCc() {
        return this.cc;
    }

    public String getBcc() {
        return this.bcc;
    }

    public boolean isImagesEnabled() {
        return this.imagesEnabled;
    }

    public boolean isBccSender() {
        return this.bccSender;
    }

    private OutgoingEmailConfig() {
    }
}

