/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.net;

import java.net.NetworkInterface;
import java.util.Enumeration;

public final class AnahataNetUtils {
    public static byte[] getMacAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                if (ni.isLoopback() || ni.isPointToPoint() || !ni.isUp()) continue;
                return ni.getHardwareAddress();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static String macToString(byte[] mac) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < mac.length; ++i) {
            sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? ":" : ""));
        }
        return sb.toString();
    }

    private AnahataNetUtils() {
    }
}

