/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.lang;

import java.util.List;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.Validate;

public final class AnahataEnumUtils {
    public static <T extends Enum> boolean in(T value, T ... options) {
        for (T object : options) {
            if (value != object) continue;
            return true;
        }
        return false;
    }

    public static <T extends Enum> List<T> exclude(Class<T> enumClass, T ... excludes) {
        List ret = EnumUtils.getEnumList(enumClass);
        for (T t : excludes) {
            Validate.isTrue((boolean)ret.contains(t), (String)"Enum Class %s does not contain value %s", (Object[])new Object[]{enumClass.getSimpleName(), t});
            ret.remove(t);
        }
        return ret;
    }

    private AnahataEnumUtils() {
    }
}

