/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.sysparam;

import com.anahata.util.sysparam.SystemParameterDataSource;
import com.anahata.util.sysparam.SystemParameterService;
import com.anahata.util.sysparam.SystemParameterValue;
import java.util.List;
import java.util.Properties;
import javax.naming.InitialContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EJBDataSource
implements SystemParameterDataSource {
    private static final Logger log = LoggerFactory.getLogger(EJBDataSource.class);
    public static final String SYSPARAM_EJB_JNDINAME = "com.anahata.util.sysparam.ejb.jndiname";

    @Override
    public Properties load() {
        Properties props = new Properties();
        try {
            String jndiName = System.getProperty(SYSPARAM_EJB_JNDINAME);
            if (jndiName == null) {
                RuntimeException e = new RuntimeException("No system property defined for the EJB JNDI NAME - com.anahata.util.sysparam.ejb.jndiname");
                log.error("No EJB JNDI system property found", (Throwable)e);
                throw e;
            }
            InitialContext ic = new InitialContext();
            SystemParameterService paramEjb = (SystemParameterService)ic.lookup(jndiName);
            List<SystemParameterValue> params = paramEjb.getAllSystemParameters();
            for (SystemParameterValue param : params) {
                props.put(param.getSystemParameterKey(), param.getSystemParameterValue());
            }
        }
        catch (Exception e) {
            log.error("Error loading database properites through the EJB", (Throwable)e);
            throw new RuntimeException(e);
        }
        return props;
    }
}

