/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.jpa;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.ManagedType;
import lombok.NonNull;

public final class JpaEntityUtils {
    public static Map<Class, Set<Class>> getSubclasses(@NonNull EntityManager em) {
        if (em == null) {
            throw new NullPointerException("em");
        }
        Set types = em.getMetamodel().getManagedTypes();
        HashMap<Class, Set<Class>> classes = new HashMap<Class, Set<Class>>();
        for (ManagedType type : types) {
            Class cls = type.getJavaType();
            JpaEntityUtils.setClass(classes, cls, null);
            if (!(type instanceof IdentifiableType)) continue;
            IdentifiableType itype = (IdentifiableType)type;
            for (IdentifiableType stype = itype.getSupertype(); stype != null; stype = stype.getSupertype()) {
                Class scls = stype.getJavaType();
                JpaEntityUtils.setClass(classes, scls, cls);
                cls = scls;
            }
        }
        return classes;
    }

    private static Set<Class> setClass(Map<Class, Set<Class>> classes, Class cls, Class subCls) {
        Set<Class> subs = classes.get(cls);
        if (subs == null) {
            subs = new HashSet<Class>();
            classes.put(cls, subs);
        }
        if (subCls != null) {
            subs.add(subCls);
            Set<Class> subs2 = classes.get(subCls);
            if (subs2 != null) {
                subs.addAll(subs2);
            }
        }
        return subs;
    }

    private JpaEntityUtils() {
    }
}

