/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.ConstructorUtils;

public final class ReflectionUtils {
    private static final String SINGLETON_INSTANCE_FIELD_NAME = "INSTANCE";
    private static final String WELD_PROXY_SUBCLASS_NAME = "$Proxy$_$$_WeldSubclass";

    public static <T> T getInstance(Class<T> clazz, Object ... args) {
        Field[] fields;
        if (clazz == null) {
            return null;
        }
        for (Field field : fields = clazz.getDeclaredFields()) {
            int mods;
            if (!clazz.equals(field.getType()) || !field.getName().equals(SINGLETON_INSTANCE_FIELD_NAME) || !Modifier.isPublic(mods = field.getModifiers()) || !Modifier.isStatic(mods) || !Modifier.isFinal(mods)) continue;
            try {
                return (T)field.get(clazz);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException("Error accessing field " + field.getName() + " of type " + field.getType().getName(), e);
            }
        }
        try {
            return ReflectionUtils.invokeConstructor(clazz, args);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception invoking constructor for class" + clazz.getName() + " with arguments: " + Arrays.toString(args) + ". Was this class ment to have a public static final " + SINGLETON_INSTANCE_FIELD_NAME + " singleton field?", e);
        }
    }

    public static List<Field> getAllDeclaredFields(Class clazz) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields()));
        fields.addAll(ReflectionUtils.getAllDeclaredFields(clazz.getSuperclass()));
        return fields;
    }

    public static String getRealClassName(Class clazz) {
        if (clazz == null) {
            return null;
        }
        return StringUtils.removeEnd((String)clazz.getName(), (String)WELD_PROXY_SUBCLASS_NAME);
    }

    public static Class forName(String className) {
        if (StringUtils.isBlank((CharSequence)className)) {
            return null;
        }
        className = StringUtils.removeEnd((String)className, (String)WELD_PROXY_SUBCLASS_NAME);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load class: " + className, e);
        }
    }

    public static <T> T invokeConstructor(Class<T> clazz, Object ... args) {
        try {
            return (T)ConstructorUtils.invokeConstructor(clazz, (Object[])args);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Unable to instantiate class: " + clazz.getName(), e);
        }
    }

    public static <T> T readField(Object object, Class<T> fieldClass, Field field) {
        Validate.notNull(fieldClass);
        Validate.notNull((Object)field);
        if (object == null) {
            return null;
        }
        if (!fieldClass.isAssignableFrom(field.getType())) {
            throw new RuntimeException("Cannot get field value for field " + field.getName() + " because it is not type " + fieldClass.getName() + ", field type is " + field.getType().getName());
        }
        field.setAccessible(true);
        try {
            return (T)field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException("Could not get field value for field " + field.getName(), e);
        }
    }

    public static Class[] getGenericArgs(Field field) {
        Validate.notNull((Object)field);
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            Type[] args = ptype.getActualTypeArguments();
            Class[] result = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                result[i] = ReflectionUtils.getRawClass(args[i]);
            }
            return result;
        }
        return null;
    }

    public static <T, U extends T> Class[] getGenericArgs(Class<T> referenceClass, Class<U> clazz) {
        Class[] result;
        for (Type type : clazz.getGenericInterfaces()) {
            Class[] result2 = ReflectionUtils.getGenericArgs(type, referenceClass);
            if (result2 == null) continue;
            return result2;
        }
        Class<U> superclass = clazz.getSuperclass();
        if (superclass != null && !Object.class.equals(superclass) && (result = ReflectionUtils.getGenericArgs(referenceClass, superclass)) != null) {
            return result;
        }
        Type type = clazz.getGenericSuperclass();
        return ReflectionUtils.getGenericArgs(type, referenceClass);
    }

    private static Class[] getGenericArgs(Type type, Class referenceClass) {
        Type[] typeArgs;
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType ptype = (ParameterizedType)type;
        Type rawType = ptype.getRawType();
        if (rawType instanceof Class && referenceClass.isAssignableFrom((Class)rawType) && (typeArgs = ptype.getActualTypeArguments()) != null) {
            Class[] types = new Class[typeArgs.length];
            for (int i = 0; i < typeArgs.length; ++i) {
                types[i] = ReflectionUtils.getRawClass(typeArgs[i]);
            }
            return types;
        }
        return null;
    }

    public static Class getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            return (Class)ptype.getRawType();
        }
        return Object.class;
    }

    public static <T, V extends T> T getInstanceIfNotBase(Class<T> baseClass, Class<V> clazz, Object ... args) {
        return clazz.equals(baseClass) ? null : (T)ReflectionUtils.getInstance(clazz, args);
    }

    public static List<Class> getHierarchy(Class clazz) {
        ArrayList<Class> hierarchy = new ArrayList<Class>();
        for (Class pathElement = clazz; pathElement != null; pathElement = pathElement.getSuperclass()) {
            hierarchy.add(0, pathElement);
        }
        return hierarchy;
    }

    private ReflectionUtils() {
    }
}

