/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.docmosis;

import com.anahata.util.io.FileModificationListener;
import com.anahata.util.io.FileMonitor;
import com.anahata.util.plaf.OSUtils;
import com.anahata.util.plaf.ProcessUtils;
import java.io.File;
import java.util.Date;

public final class DocmosisUtils {
    public static File getLibreOfficeExecutable() {
        File libreOfficeExecutalbe = OSUtils.findExecutableOnPath("soffice.exe", "soffice", "soffice");
        return libreOfficeExecutalbe;
    }

    public static boolean isLibreOfficeExecutableOnSystemPath() {
        return DocmosisUtils.getLibreOfficeExecutable() != null;
    }

    public static void editInLibreOffice(String name, byte[] data, FileModificationListener listener) throws Exception {
        if (!DocmosisUtils.isLibreOfficeExecutableOnSystemPath()) {
            throw new IllegalStateException("LibreOffice not found on system path");
        }
        ProcessUtils.editFile(DocmosisUtils.getLibreOfficeExecutable(), name, ".~lock.%s#", data, listener);
    }

    public static void main(String[] args) throws Exception {
        DocmosisUtils.editInLibreOffice("popo.txt", "some text".getBytes(), new FileModificationListener(){

            @Override
            public void fileModified(FileMonitor monitor, Date prevLastModified, Date newLastModified) {
                System.out.println("!!! File modified");
            }
        });
        while (true) {
            Thread.sleep(500L);
        }
    }

    private DocmosisUtils() {
    }
}

