/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.reflect;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.Validate;

public final class AnahataPropertyUtils {
    public static Object getProperty(Object bean, String name) {
        try {
            return PropertyUtils.getProperty((Object)bean, (String)name);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> describe(Object bean, Class stopClass, boolean includeStopClass) {
        PropertyDescriptor[] descriptors;
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (PropertyDescriptor descriptor : descriptors = PropertyUtils.getPropertyDescriptors((Object)bean)) {
            Class<?> declaringClass;
            if (descriptor.getReadMethod() == null || (declaringClass = descriptor.getReadMethod().getDeclaringClass()).equals(stopClass) && !includeStopClass || !stopClass.isAssignableFrom(declaringClass)) continue;
            ret.put(descriptor.getName(), AnahataPropertyUtils.getProperty(bean, descriptor.getName()));
        }
        return ret;
    }

    public static PropertyDescriptor getPropertyDescriptor(Class beanClass, String name) {
        PropertyDescriptor[] descriptors;
        Validate.notNull((Object)beanClass);
        Validate.notNull((Object)name);
        for (PropertyDescriptor descriptor : descriptors = PropertyUtils.getPropertyDescriptors((Class)beanClass)) {
            if (!descriptor.getName().equals(name)) continue;
            return descriptor;
        }
        return null;
    }

    public static void copyProperties(Object dest, Object orig) {
        try {
            PropertyUtils.copyProperties((Object)dest, (Object)orig);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map describe(Object bean) {
        try {
            return PropertyUtils.describe((Object)bean);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static PropertyDescriptor getPropertyDescriptor(Object bean, String name) {
        try {
            return PropertyUtils.getPropertyDescriptor((Object)bean, (String)name);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class getPropertyType(Object bean, String name) {
        try {
            return PropertyUtils.getPropertyType((Object)bean, (String)name);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setProperty(Object bean, String name, Object value) throws RuntimeException, NestedNullException {
        try {
            PropertyUtils.setProperty((Object)bean, (String)name, (Object)value);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean setPropertyNulls(Object bean, String name, Object value) {
        try {
            PropertyUtils.setProperty((Object)bean, (String)name, (Object)value);
            return true;
        }
        catch (NestedNullException e) {
            return false;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private AnahataPropertyUtils() {
    }
}

