/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.cdi;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import com.anahata.util.logging.logback.ErrorEventAppender;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionTarget;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

public class LogbackWeldExtension
implements Extension {
    private static final Logger log = LoggerFactory.getLogger(LogbackWeldExtension.class);

    public void bind(@Observes AfterDeploymentValidation event, BeanManager manager) {
        ILoggerFactory loggerFactory = StaticLoggerBinder.getSingleton().getLoggerFactory();
        if (loggerFactory instanceof LoggerContext) {
            List loggers = ((LoggerContext)loggerFactory).getLoggerList();
            for (ch.qos.logback.classic.Logger logger : loggers) {
                Appender appender = this.findAppender(logger);
                if (appender == null) continue;
                AnnotatedType type = manager.createAnnotatedType(appender.getClass());
                InjectionTarget target = manager.createInjectionTarget(type);
                CreationalContext creationalContext = manager.createCreationalContext(null);
                target.inject((Object)appender, creationalContext);
            }
        } else {
            log.warn("LogbackWeldExtension could not find Logback's LoggerContext instead found {} as StaticLoggerBinder.getSingleton().getLoggerFactory(). Most likely the logback-classic dependency is not available on the class path or there is another SLF4J binding before on the classpth. Check SLF4J initialization logs", (Object)loggerFactory);
        }
    }

    private Appender findAppender(ch.qos.logback.classic.Logger logger) {
        Iterator i = logger.iteratorForAppenders();
        while (i.hasNext()) {
            Appender appender = (Appender)i.next();
            if (!(appender instanceof ErrorEventAppender)) continue;
            return appender;
        }
        return null;
    }
}

