/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.jpa.eclipselink;

import com.anahata.util.jpa.JPAPropertyUtils;
import com.anahata.util.jpa.JpaEntityUtils;
import com.anahata.util.jpa.JpaPropertyDescriptor;
import com.anahata.util.jpa.eclipselink.BasicCopyGroupFactory;
import com.anahata.util.jpa.eclipselink.CloningCopyGroupFactory;
import com.anahata.util.jpa.eclipselink.CopyGroupAttribute;
import com.anahata.util.jpa.eclipselink.CopyGroupFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.Attribute;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.eclipse.persistence.sessions.CopyGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyGroupFactoryBuilder {
    private static final Logger log = LoggerFactory.getLogger(CopyGroupFactoryBuilder.class);
    private final Class baseClass;
    private int depth = 1;
    private final Set<Class> includeClasses = new HashSet<Class>();
    private final Set<Class> excludeClasses = new HashSet<Class>();
    private final Map<Class, CopyGroup> predefined = new HashMap<Class, CopyGroup>();
    private final Map<Class, Set<String>> excludeAttributes = new HashMap<Class, Set<String>>();
    private final Map<Class, Set<Class>> subClasses;

    public CopyGroupFactoryBuilder(@NonNull EntityManager em, @NonNull Class baseClass) {
        if (em == null) {
            throw new NullPointerException("em");
        }
        if (baseClass == null) {
            throw new NullPointerException("baseClass");
        }
        log.trace("--> CopyGroupFactoryBuilder() {}", (Object)baseClass);
        this.baseClass = baseClass;
        this.subClasses = JpaEntityUtils.getSubclasses(em);
        log.trace("<-- CopyGroupFactoryBuilder() {}", (Object)baseClass);
    }

    public CopyGroupFactoryBuilder depth(int depth) {
        Validate.isTrue((depth >= 1 ? 1 : 0) != 0, (String)"The depth must be >= 1", (Object[])new Object[0]);
        this.depth = depth;
        return this;
    }

    public CopyGroupFactoryBuilder includeClass(Class clazz) {
        Validate.notNull((Object)clazz);
        this.includeClasses.add(clazz);
        return this;
    }

    public CopyGroupFactoryBuilder predefined(Class clazz, CopyGroup cg, boolean includeSubclasses) {
        Validate.notNull((Object)clazz);
        this.predefined.put(clazz, cg);
        if (includeSubclasses) {
            for (Class subclass : this.subClasses.get(clazz)) {
                this.predefined.put(subclass, cg);
            }
        }
        return this;
    }

    public CopyGroupFactoryBuilder excludeClass(Class clazz) {
        Validate.notNull((Object)clazz);
        this.excludeClasses.add(clazz);
        return this;
    }

    public CopyGroupFactoryBuilder excludeAttributes(Class clazz, Attribute ... attributes) {
        Validate.notNull((Object)clazz);
        Validate.notNull((Object)attributes);
        Validate.isTrue((attributes.length >= 1 ? 1 : 0) != 0, (String)"At least one attribute must be provided to exclude", (Object[])new Object[0]);
        Set<String> attrs = this.excludeAttributes.get(clazz);
        if (attrs == null) {
            attrs = new HashSet<String>();
            this.excludeAttributes.put(clazz, attrs);
        }
        for (Attribute attr : attributes) {
            attrs.add(attr.getName());
        }
        return this;
    }

    public CopyGroupFactoryBuilder excludeAttributes(Class clazz, String ... attributes) {
        Validate.notNull((Object)clazz);
        Validate.notNull((Object)attributes);
        Validate.isTrue((attributes.length >= 1 ? 1 : 0) != 0, (String)"At least one attribute must be provided to exclude", (Object[])new Object[0]);
        Set<String> attrs = this.excludeAttributes.get(clazz);
        if (attrs == null) {
            attrs = new HashSet<String>();
            this.excludeAttributes.put(clazz, attrs);
        }
        attrs.addAll(Arrays.asList(attributes));
        return this;
    }

    public CopyGroupFactory build() {
        log.trace("--> CopyGroupFactoryBuilder.build() {}", (Object)this.baseClass);
        CopyGroup cg = this.predefined.get(this.baseClass);
        if (cg != null) {
            return new CloningCopyGroupFactory(cg);
        }
        HashMap<Class, Set<CopyGroupAttribute>> attrMap = new HashMap<Class, Set<CopyGroupAttribute>>();
        HashMap<Class, CopyGroupAttribute> postProcessMap = new HashMap<Class, CopyGroupAttribute>();
        this.scan(attrMap, postProcessMap, this.baseClass, this.depth);
        for (Map.Entry postEntry : postProcessMap.entrySet()) {
            if (!attrMap.containsKey(postEntry.getKey())) continue;
            log.trace("build: post-setting refclass for class {}", (Object)((Class)postEntry.getKey()).getSimpleName());
            ((CopyGroupAttribute)postEntry.getValue()).setRefClass((Class)postEntry.getKey());
        }
        log.trace("<-- CopyGroupFactoryBuilder.build() {}", (Object)this.baseClass);
        return new BasicCopyGroupFactory(this.baseClass, attrMap, this.predefined);
    }

    private void scan(Map<Class, Set<CopyGroupAttribute>> attrMap, Map<Class, CopyGroupAttribute> postProcessMap, Class clazz, int currDepth) {
        String indent = StringUtils.leftPad((String)"", (int)(this.depth - currDepth), (String)" ");
        log.trace("{} {} scan : entry {}.", new Object[]{this.baseClass.getSimpleName(), indent, clazz});
        if (attrMap.keySet().contains(clazz)) {
            return;
        }
        if (this.predefined.containsKey(clazz)) {
            log.trace("{} {} scan : predefined contains {}. Will skip ", new Object[]{this.baseClass.getSimpleName(), indent, clazz});
            return;
        }
        String className = clazz.getSimpleName();
        HashSet<CopyGroupAttribute> attrs = new HashSet<CopyGroupAttribute>();
        attrMap.put(clazz, attrs);
        Map<String, JpaPropertyDescriptor> props = JPAPropertyUtils.describe(clazz);
        Set<Class> classes = this.subClasses.get(clazz);
        if (classes != null) {
            for (Class c : classes) {
                props.putAll(JPAPropertyUtils.describe(c));
            }
        }
        Set<String> excludeAttrs = this.excludeAttributes.get(clazz);
        for (JpaPropertyDescriptor prop : props.values()) {
            String propName = prop.getPropertyName();
            log.trace("{} {} scan : Processing prop {}.{} ", new Object[]{this.baseClass.getSimpleName(), indent, className, propName});
            if (excludeAttrs != null && excludeAttrs.contains(propName)) continue;
            if ((prop.isRelationship() || prop.isEmbedded()) && !this.excludeClasses.contains(prop.getEntityType())) {
                Class entityType = prop.getEntityType();
                if (currDepth > 1 || this.includeClasses.contains(entityType)) {
                    this.scan(attrMap, postProcessMap, entityType, currDepth - 1);
                }
                if (attrMap.keySet().contains(entityType) || this.predefined.containsKey(entityType)) {
                    log.trace("{} {} scan : Adding prop {}.{} => {}", new Object[]{this.baseClass.getSimpleName(), indent, className, propName, entityType.getSimpleName()});
                    attrs.add(new CopyGroupAttribute(propName, entityType));
                    continue;
                }
                log.trace("{} {} scan : Adding prop {}.{} => PENDING", new Object[]{this.baseClass.getSimpleName(), indent, className, propName});
                CopyGroupAttribute cga = new CopyGroupAttribute(propName, null);
                attrs.add(cga);
                postProcessMap.put(entityType, cga);
                continue;
            }
            log.trace("{} {} scan : Adding prop {}.{}", new Object[]{this.baseClass.getSimpleName(), indent, className, propName});
            attrs.add(new CopyGroupAttribute(propName, null));
        }
        log.trace("{} {} scan : exit {}.", new Object[]{this.baseClass.getSimpleName(), indent, clazz});
    }

    public Class getBaseClass() {
        return this.baseClass;
    }
}

