/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.transport.rpc;

import com.anahata.util.cdi.Cdi;
import com.anahata.util.io.AnahataCompressionUtils;
import com.anahata.util.io.AnahataSerializationUtils;
import com.anahata.util.io.CompressionType;
import com.anahata.util.io.SerializationType;
import com.anahata.util.transport.rpc.RpcStreamer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Rpc
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Rpc.class);
    private static final Map<String, Class<?>> primitiveClasses = new HashMap();
    private String clazz;
    private String methodName;
    private String[] methodParamTypes;
    private Object[] args;

    private Rpc() {
    }

    public Rpc(Method method, Object[] args) {
        this(method.getDeclaringClass(), method, args);
    }

    public Rpc(Class clazz, Method method, Object[] args) {
        this.clazz = clazz.getName();
        this.methodName = method.getName();
        this.methodParamTypes = new String[method.getParameterTypes().length];
        for (int i = 0; i < this.methodParamTypes.length; ++i) {
            this.methodParamTypes[i] = method.getParameterTypes()[i].getName();
        }
        this.args = args;
    }

    public Class getClazz() throws ClassNotFoundException {
        return Class.forName(this.clazz);
    }

    public Method getMethod() throws NoSuchMethodException, ClassNotFoundException {
        Class loadedClazz = this.getClazz();
        Class[] paramTypes = this.getMethodParamTypes();
        log.trace("Class {}, ", (Object)loadedClazz);
        log.trace("Parameter Types {}, ", (Object[])paramTypes);
        log.trace("Method name {}, ", (Object)this.methodName);
        Method method = MethodUtils.getAccessibleMethod((Class)loadedClazz, (String)this.methodName, (Class[])paramTypes);
        Validate.notNull((Object)method, (String)"Could not find accessible method for %s.%s %s", (Object[])new Object[]{this.clazz, this.methodName, paramTypes});
        log.trace("Method {}, ", (Object)method);
        return method;
    }

    public Object invoke(Object target) throws NoSuchMethodException, ClassNotFoundException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.getMethod().invoke(target, this.args);
    }

    private Class[] getMethodParamTypes() throws ClassNotFoundException {
        Class[] ret = new Class[this.methodParamTypes.length];
        for (int i = 0; i < this.methodParamTypes.length; ++i) {
            ret[i] = Rpc.loadClass(this.methodParamTypes[i]);
        }
        return ret;
    }

    public String toString() {
        return "RpcRequest{clazz=" + this.clazz + ", methodName=" + this.methodName + ", methodParamTypes=" + Arrays.toString(this.methodParamTypes) + ", args=" + this.args + '}';
    }

    private static Class<?> loadClass(String name) throws ClassNotFoundException {
        if (primitiveClasses.containsKey(name)) {
            return primitiveClasses.get(name);
        }
        return Class.forName(name);
    }

    public static Rpc parse(Message message) throws JMSException, IOException, CompressorException {
        RpcStreamer streamer = Cdi.get(RpcStreamer.class, new Annotation[0]);
        CompressionType compression = AnahataCompressionUtils.readHeader(message);
        SerializationType serialization = AnahataSerializationUtils.readHeader(message);
        streamer.setCompressionType(compression);
        streamer.setSerializationType(serialization);
        BytesMessage bytesMessage = (BytesMessage)message;
        log.trace("BodyLength: {}", (Object)bytesMessage.getBodyLength());
        byte[] barr = new byte[(int)bytesMessage.getBodyLength()];
        bytesMessage.readBytes(barr);
        log.trace("received bytes {} ", (Object)barr);
        Rpc rpc = (Rpc)streamer.uncompressDeserialize(barr);
        return rpc;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object[] getArgs() {
        return this.args;
    }

    static {
        primitiveClasses.put("byte", Byte.TYPE);
        primitiveClasses.put("short", Short.TYPE);
        primitiveClasses.put("char", Character.TYPE);
        primitiveClasses.put("int", Integer.TYPE);
        primitiveClasses.put("long", Long.TYPE);
        primitiveClasses.put("float", Float.TYPE);
        primitiveClasses.put("double", Double.TYPE);
        primitiveClasses.put("boolean", Boolean.TYPE);
    }
}

