/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.jpa;

import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Embedded;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;

public final class JpaPropertyDescriptor {
    private String propertyName;
    private Class type;
    private Class[] genericTypes;
    private final Set<Class<? extends Annotation>> annotations = new HashSet<Class<? extends Annotation>>();

    void addAnnotation(Class<? extends Annotation> annotation) {
        this.annotations.add(annotation);
    }

    public boolean isOneToMany() {
        return this.annotations.contains(OneToMany.class);
    }

    public boolean isManyToOne() {
        return this.annotations.contains(ManyToOne.class);
    }

    public boolean isOneToOne() {
        return this.annotations.contains(OneToOne.class);
    }

    public boolean isManyToMany() {
        return this.annotations.contains(ManyToMany.class);
    }

    public boolean isEmbedded() {
        return this.annotations.contains(Embedded.class);
    }

    public boolean isTransient() {
        return this.annotations.contains(Transient.class);
    }

    public boolean isRelationship() {
        return this.isOneToMany() || this.isManyToOne() || this.isOneToOne() || this.isManyToMany();
    }

    public Class getEntityType() {
        if (Collection.class.isAssignableFrom(this.type)) {
            return this.genericTypes[0];
        }
        if (this.isEmbedded() || this.isRelationship()) {
            return this.type;
        }
        throw new IllegalStateException("property " + this.propertyName + " does not represent an entity type");
    }

    @ConstructorProperties(value={"propertyName", "type", "genericTypes"})
    public JpaPropertyDescriptor(String propertyName, Class type, Class[] genericTypes) {
        this.propertyName = propertyName;
        this.type = type;
        this.genericTypes = genericTypes;
    }

    private JpaPropertyDescriptor() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JpaPropertyDescriptor)) {
            return false;
        }
        JpaPropertyDescriptor other = (JpaPropertyDescriptor)o;
        String this$propertyName = this.getPropertyName();
        String other$propertyName = other.getPropertyName();
        return !(this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $propertyName = this.getPropertyName();
        result = result * 59 + ($propertyName == null ? 0 : $propertyName.hashCode());
        return result;
    }

    public String toString() {
        return "JpaPropertyDescriptor(propertyName=" + this.getPropertyName() + ", type=" + this.getType() + ", genericTypes=" + Arrays.deepToString(this.genericTypes) + ", annotations=" + this.annotations + ")";
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Class getType() {
        return this.type;
    }
}

