/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.jsf;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageTranslator {
    private static final Logger log = LoggerFactory.getLogger(MessageTranslator.class);
    private static final String MSG_BUNDLE_PATH = "app.messages";

    public static String translate(String key, Locale locale) {
        Validate.notNull((Object)key);
        Validate.notNull((Object)locale);
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(MSG_BUNDLE_PATH, locale);
            if (bundle != null) {
                return bundle.getString(key);
            }
        }
        catch (Exception ex) {
            log.error("Cannot translate string {} with locale {}. Cause = {}", new Object[]{key, locale, ex});
        }
        return key;
    }

    public static String translate(String key, Object ... args) {
        Locale userLocale = MessageTranslator.getUserLocale();
        return MessageFormat.format(MessageTranslator.translate(key, userLocale), args);
    }

    public static Locale getUserLocale() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context == null) {
            log.debug("getUserLocale: No faces context, returning default of en");
            return Locale.ENGLISH;
        }
        ExternalContext externalContext = context.getExternalContext();
        if (externalContext == null) {
            log.debug("getUserLocale: No external context, returning default of en");
            return Locale.ENGLISH;
        }
        log.debug("getUserLocale: Returning external context locale of {}", (Object)externalContext.getRequestLocale());
        return externalContext.getRequestLocale();
    }

    private MessageTranslator() {
    }
}

