/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.plaf;

import com.anahata.util.lang.AnahataStringUtils;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Validate;

public final class AnahataFilenameUtils {
    public static final String DEFAULT_ILLGEAL_FILE_NAME_CHARACTER_REPLACEMENT_VALUE = "_";
    public static final String NAME_TOO_LONG_CONCAT_TOKEN = "...";
    public static final int NAME_TOO_LONG_CONCAT_TOKEN_DITANCE_FROM_BASE_NAME_END = 10;
    public static final char[] ILLEGAL_FILE_NAME_CHARACTERS = new char[]{'/', '?', '<', '>', '\\', ':', '*', '|', '\"'};
    public static final int MAX_FILE_NAME_LENGTH = 256;
    public static final Pattern VALID_FILE_NAME_PATTERN = Pattern.compile("# Match a valid Windows filename (unspecified file system).          \n^                                # Anchor to start of string.        \n(?!                              # Assert filename is not: CON, PRN, \n  (?:                            # AUX, NUL, COM1, COM2, COM3, COM4, \n    CON|PRN|AUX|NUL|             # COM5, COM6, COM7, COM8, COM9,     \n    COM[1-9]|LPT[1-9]            # LPT1, LPT2, LPT3, LPT4, LPT5,     \n  )                              # LPT6, LPT7, LPT8, and LPT9...     \n  (?:\\.[^.]*)?                  # followed by optional extension    \n  $                              # and end of string                 \n)                                # End negative lookahead assertion. \n[^<>:\"/\\\\|?*\\x00-\\x1F]*     # Zero or more valid filename chars.\n[^<>:\"/\\\\|?*\\x00-\\x1F\\ .]  # Last char is not a space or dot.  \n$                                # Anchor to end of string.            ", 70);

    public static String replaceIllegalCharacters(String fileName, String replaceToken) {
        return AnahataStringUtils.replaceChars(fileName, ILLEGAL_FILE_NAME_CHARACTERS, replaceToken);
    }

    public static String replaceIllegalCharacters(String fileName) {
        return AnahataStringUtils.replaceChars(fileName, ILLEGAL_FILE_NAME_CHARACTERS, DEFAULT_ILLGEAL_FILE_NAME_CHARACTER_REPLACEMENT_VALUE);
    }

    public static boolean isValidFileName(String fileName) {
        Validate.notNull((Object)fileName);
        boolean patternValid = VALID_FILE_NAME_PATTERN.matcher(fileName).matches();
        return patternValid && fileName.length() <= 256;
    }

    public static String trimToMaxLength(String fileName) {
        Validate.notNull((Object)fileName);
        if (fileName.length() > 256) {
            String ext = FilenameUtils.getExtension((String)fileName);
            int maxExtLength = 244;
            if (ext.length() > maxExtLength) {
                throw new IllegalArgumentException("Extension is too long for this alogrithm. Extension length=" + ext.length() + " max= " + ext.length() + " File name:" + fileName);
            }
            if (!ext.isEmpty()) {
                ext = "." + ext;
            }
            int maxBaseLength = 256 - ext.length();
            String base = FilenameUtils.getBaseName((String)fileName);
            String baseSplitter = NAME_TOO_LONG_CONCAT_TOKEN;
            int baseTrimDistanceFromEnd = 10;
            String basePreffix = fileName.substring(0, maxBaseLength - baseTrimDistanceFromEnd);
            String baseSuffix = base.substring(base.length() - (baseTrimDistanceFromEnd - baseSplitter.length()));
            return basePreffix + baseSplitter + baseSuffix + ext;
        }
        return fileName;
    }

    public static String toValidFileName(String fileName) {
        return AnahataFilenameUtils.trimToMaxLength(AnahataFilenameUtils.replaceIllegalCharacters(fileName));
    }

    private AnahataFilenameUtils() {
    }
}

