/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.jpa.eclipselink;

import com.anahata.util.jpa.JPAPropertyUtils;
import com.anahata.util.jpa.JpaEntityUtils;
import com.anahata.util.jpa.JpaPropertyDescriptor;
import com.anahata.util.jpa.eclipselink.TypedCopyGroup;
import com.anahata.util.reflect.ReflectionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.Attribute;
import lombok.NonNull;
import org.apache.commons.lang3.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyGroupFactory2
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(CopyGroupFactory2.class);
    private final Map<Class, Set<Class>> subClasses;
    private final Set<Class> topLevel = new HashSet<Class>();
    private final Map<Class, TypedCopyGroup> groups = new HashMap<Class, TypedCopyGroup>();

    public CopyGroupFactory2(@NonNull EntityManager em) {
        if (em == null) {
            throw new NullPointerException("em");
        }
        this.subClasses = JpaEntityUtils.getSubclasses(em);
        for (Class c : this.subClasses.keySet()) {
            log.trace("Subclasses of {}: {}", (Object)c, this.subClasses.get(c));
            this.topLevel.add(this.getCopyGroupClass(c));
        }
        log.trace("top level entities: {}", this.topLevel);
        for (Class class1 : this.topLevel) {
            this.getCopyGroup(class1);
        }
    }

    public CopyGroupFactory2(@NonNull EntityManager em, Class c) {
        if (em == null) {
            throw new NullPointerException("em");
        }
        this.subClasses = JpaEntityUtils.getSubclasses(em);
        this.getCopyGroup(c);
    }

    public CopyGroupFactory2 excludeAttribute(Attribute att) {
        Class clazz = att.getDeclaringType().getJavaType();
        this.getGroup(clazz).removeAttribute(att.getName());
        return this;
    }

    public TypedCopyGroup newInstance(Class c) {
        TypedCopyGroup template = this.getGroup(c);
        return (TypedCopyGroup)((Object)SerializationUtils.clone((Serializable)((Object)template)));
    }

    public TypedCopyGroup getGroup(Class type) {
        type = this.getCopyGroupClass(type);
        return this.groups.get(type);
    }

    private TypedCopyGroup getCopyGroup(Class clazz) {
        if (this.groups.containsKey(clazz = this.getCopyGroupClass(clazz))) {
            return this.groups.get(clazz);
        }
        log.trace("Didn't have copyGroup for class {}, currentGroups = {}", (Object)clazz, this.groups.keySet());
        ArrayList<JpaPropertyDescriptor> props = new ArrayList<JpaPropertyDescriptor>(JPAPropertyUtils.describe(clazz).values());
        Set<Class> subclasses = this.subClasses.get(clazz);
        if (subclasses != null) {
            for (Class c : subclasses) {
                props.addAll(new ArrayList<JpaPropertyDescriptor>(JPAPropertyUtils.describe(c, false, false, null).values()));
            }
        }
        ArrayList<Class> allTypes = new ArrayList<Class>();
        allTypes.add(clazz);
        if (subclasses != null) {
            allTypes.addAll(subclasses);
        }
        TypedCopyGroup cg = new TypedCopyGroup(false, allTypes.toArray(new Class[allTypes.size()]));
        log.trace("Storing group for " + clazz);
        this.groups.put(clazz, cg);
        for (JpaPropertyDescriptor jpd : props) {
            if (jpd.isRelationship() || jpd.isEmbedded()) {
                cg.addAttribute(jpd.getPropertyName(), this.getCopyGroup(jpd.getEntityType()));
                continue;
            }
            cg.addAttribute(jpd.getPropertyName());
        }
        return cg;
    }

    private Class getCopyGroupClass(Class clazz) {
        Class ret = clazz;
        List<Class> hierarchy = ReflectionUtils.getHierarchy(clazz);
        for (Class hierarchyElement : hierarchy) {
            if (!hierarchyElement.isAnnotationPresent(Entity.class) || !this.subClasses.containsKey(hierarchyElement)) continue;
            ret = hierarchyElement;
            break;
        }
        log.trace("CopyGroup class for {} = {} ", (Object)clazz, (Object)ret);
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (Class c : this.groups.keySet()) {
            sb.append("------------------------- ").append(++i).append("/").append(this.groups.size()).append(" ").append(c.getName()).append("--------------------------------");
            sb.append((Object)this.groups.get(c));
        }
        return sb.toString();
    }
}

