/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.io;

import com.anahata.util.io.SerializationType;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.servlet.http.HttpServletRequest;

public final class AnahataSerializationUtils {
    public static final String HEADER = "AnahataSerialization";

    public static SerializationType readHeader(HttpServletRequest request) {
        return AnahataSerializationUtils.parse(request.getHeader(HEADER));
    }

    public static SerializationType readHeader(Message message) throws JMSException {
        return AnahataSerializationUtils.parse(message.getStringProperty(HEADER));
    }

    public static SerializationType parse(String serialization) {
        SerializationType ret = null;
        if (serialization != null) {
            ret = SerializationType.valueOf(serialization);
        }
        return ret;
    }

    private AnahataSerializationUtils() {
    }
}

