/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.io;

import com.anahata.util.io.FileModificationListener;
import java.io.File;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileMonitor
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(FileMonitor.class);
    public static final long POLL_INTERVAL = 500L;
    public static ExecutorService fileWatchThreadPool = Executors.newCachedThreadPool(new ThreadFactory(){
        volatile int threadCount = 1;

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName("File modif thread " + this.threadCount++);
            t.setDaemon(true);
            t.setPriority(1);
            return t;
        }
    });
    private File file;
    private FileModificationListener listener;
    private boolean running = true;

    public FileMonitor(File file, FileModificationListener listener) {
        Validate.notNull((Object)file, (String)"file is required", (Object[])new Object[0]);
        this.file = file;
        this.listener = listener;
        fileWatchThreadPool.submit(this);
    }

    public void close() {
        this.running = false;
    }

    @Override
    public void run() {
        log.debug("File monitor launched for {}", (Object)this.file);
        long lastPromptTime = this.file.lastModified();
        while (this.running && !Thread.currentThread().isInterrupted()) {
            if (this.file.lastModified() > lastPromptTime) {
                this.listener.fileModified(this, new Date(lastPromptTime), new Date(this.file.lastModified()));
                lastPromptTime = this.file.lastModified();
                log.trace("File got modified file={}, prev modified date ={}, current modified date={}", new Object[]{this.file, new Date(lastPromptTime), this.file.lastModified()});
            } else {
                log.debug("File {} hasn't changed last modified = {}", (Object)this.file.getName(), (Object)new Date(this.file.lastModified()));
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                log.warn("Watch interrupted while monitoring file " + this.file, (Throwable)e);
            }
            log.trace("running = {}, interrupted={}", (Object)this.running, (Object)Thread.currentThread().isInterrupted());
        }
        this.running = false;
        log.debug("File monitor finished for {}", (Object)this.file);
    }

    private FileMonitor() {
    }

    public File getFile() {
        return this.file;
    }

    public FileModificationListener getListener() {
        return this.listener;
    }

    public boolean isRunning() {
        return this.running;
    }
}

