/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.swing;

import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MacOSUIManager {
    private static final Logger LOG = LoggerFactory.getLogger(MacOSUIManager.class);
    private static final int MAC_META = 260;
    private static final KeyStroke WINDOWS_COPY = KeyStroke.getKeyStroke(67, 128);
    private static final KeyStroke MAC_COPY = KeyStroke.getKeyStroke(67, 260);
    private static final KeyStroke WINDOWS_PASTE = KeyStroke.getKeyStroke(86, 128);
    private static final KeyStroke MAC_PASTE = KeyStroke.getKeyStroke(86, 260);
    private static final KeyStroke WINDOWS_CUT = KeyStroke.getKeyStroke(88, 128);
    private static final KeyStroke MAC_CUT = KeyStroke.getKeyStroke(88, 260);

    public static void addCopyPasteShortcutsWithMetaForMac() {
        UIDefaults defaults = UIManager.getLookAndFeel().getDefaults();
        for (Object entryKey : defaults.keySet()) {
            String keyToString = entryKey.toString();
            if (!keyToString.contains("Text") || !keyToString.contains("focusInputMap")) continue;
            LOG.info("addCopyPasteShortcutsWithMetaForMac: Will attempt to modify shortcuts for {}", (Object)keyToString);
            InputMap inputMap = null;
            Object maybeInputMap = defaults.get(entryKey);
            if (maybeInputMap instanceof InputMap) {
                inputMap = (InputMap)maybeInputMap;
            } else if (maybeInputMap instanceof UIDefaults.LazyInputMap) {
                UIDefaults.LazyInputMap lazyInputMap = (UIDefaults.LazyInputMap)maybeInputMap;
                inputMap = (InputMap)lazyInputMap.createValue(UIManager.getDefaults());
            } else {
                LOG.warn("Unknown input map: {}", maybeInputMap);
                continue;
            }
            try {
                MacOSUIManager.updateInputMapToMacWay(inputMap);
                defaults.put(entryKey, inputMap);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    public static void updateInputMapToMacWay(InputMap im) {
        KeyStroke[] ks;
        for (KeyStroke keyStroke : ks = im.keys()) {
            if (WINDOWS_COPY.equals(keyStroke)) {
                im.put(MAC_COPY, (String)im.get(keyStroke));
                continue;
            }
            if (WINDOWS_CUT.equals(keyStroke)) {
                im.put(MAC_CUT, (String)im.get(keyStroke));
                continue;
            }
            if (!WINDOWS_PASTE.equals(keyStroke)) continue;
            im.put(MAC_PASTE, (String)im.get(keyStroke));
        }
    }

    private MacOSUIManager() {
    }
}

