/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.commons.lang3.Validate;

public abstract class JpaBase {
    private final EntityManager em;
    private final EntityTransaction tx;

    protected JpaBase(EntityManager em) {
        Validate.notNull((Object)em);
        this.em = em;
        this.tx = em.getTransaction();
    }

    protected final void begin() {
        this.tx.begin();
    }

    protected final void commit() {
        this.tx.commit();
    }

    protected final void rollback() {
        this.tx.rollback();
    }

    protected final void persist(Object obj) {
        this.em.persist(obj);
    }

    protected final <T> T merge(T t) {
        return (T)this.em.merge(t);
    }

    protected final void flush() {
        this.em.flush();
    }

    protected final <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)this.em.find(entityClass, primaryKey);
    }

    protected final <T> T find(Class<T> entityClass, Enum primaryKey) {
        return (T)this.em.find(entityClass, (Object)primaryKey.name());
    }

    protected final <T> T querySingle(String query, Class<T> resultClass) {
        return (T)this.em.createQuery(query, resultClass).getSingleResult();
    }

    protected final <T> List<T> query(String query, Class<T> resultClass) {
        return this.em.createQuery(query, resultClass).getResultList();
    }

    protected final int update(String query) {
        return this.em.createQuery(query).executeUpdate();
    }

    protected final int truncate(Class entity) {
        return this.em.createQuery("delete from " + entity.getSimpleName()).executeUpdate();
    }

    public EntityManager getEm() {
        return this.em;
    }
}

