/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.plaf;

import com.anahata.util.io.AnahataFileUtils;
import com.anahata.util.io.FileModificationListener;
import com.anahata.util.io.FileMonitor;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProcessUtils {
    private static final Logger log = LoggerFactory.getLogger(ProcessUtils.class);

    public static void editFile(File editor, String name, String lockFileNamePattern, byte[] data, FileModificationListener listener) throws IOException, InterruptedException {
        File file = AnahataFileUtils.createTempFile(name, data);
        File lockFile = lockFileNamePattern != null ? new File(file.getParent(), String.format(lockFileNamePattern, name)) : null;
        ProcessBuilder pb = new ProcessBuilder(editor.getAbsolutePath(), file.getAbsolutePath());
        pb.directory(file.getParentFile());
        log.debug("Launching {} {} ", (Object)editor, (Object)name);
        Process process = pb.start();
        FileMonitor fm = new FileMonitor(file, listener);
        int exitCode = process.waitFor();
        log.debug("Editor Process {} {} finished with exit code: {} ", new Object[]{editor, name, exitCode});
        if (lockFile != null) {
            log.debug("Checking if lock file still present: editor={} file={} lockFile={}", new Object[]{editor, name, lockFile});
            do {
                Thread.sleep(500L);
            } while (lockFile.exists());
            log.debug("Lock file not present: editor={} file={} lockFile={}", new Object[]{editor, name, lockFile});
        }
        log.debug("Closing file monitor for {} {} ", (Object)editor, (Object)name);
        fm.close();
    }

    private ProcessUtils() {
    }
}

