/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.email;

import com.anahata.util.mime.MimeUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ByteArrayAttachment
implements DataSource {
    private static final Logger log = LoggerFactory.getLogger(ByteArrayAttachment.class);
    private String name;
    private byte[] data;
    private String mimeType;

    public ByteArrayAttachment(String name, byte[] data) {
        this.name = name;
        this.data = data;
        try {
            this.mimeType = MimeUtils.getMimeType(data, name);
        }
        catch (Exception e) {
            log.error("Error computing attachments mime type", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getContentType() {
        return this.mimeType;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getData() {
        return this.data;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    private ByteArrayAttachment() {
    }
}

