/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.transport;

import com.anahata.util.application.JWSUtils;
import com.anahata.util.config.internal.AnahataUtilConfig;
import com.anahata.util.logging.RemoteServiceLogger;
import com.anahata.util.transport.RemoteServiceFactory;
import com.anahata.util.transport.TransportLayer;
import com.anahata.util.transport.rpc.client.RpcInvocationHandler;
import com.anahata.util.transport.rpc.client.impl.CommonsRpcClientTransport;
import com.caucho.hessian.client.HessianProxyFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang3.Validate;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.SystemDefaultCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class RemoteServiceFactoryImpl
implements RemoteServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(RemoteServiceFactoryImpl.class);
    private static final String HESSIAN_SERVLET_PATH = "/hessian/";
    private static final String RPC_SERVLET_PATH = "/rpc/";
    @Inject
    private AnahataUtilConfig config;
    @Inject
    private JWSUtils jwsUtils;
    @Inject
    private CommonsRpcClientTransport transport;
    @Inject
    private Instance<RemoteServiceLogger> removeServiceLoggerFactory;
    private String baseHessianURL;
    private URL rpcURL;
    private final HessianProxyFactory factory = new HessianProxyFactory();
    private InitialContext remoteEJBInitialContext = null;
    private final HashMap<Class, Object> cache = new HashMap();
    private CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)new SystemDefaultCredentialsProvider()).build();

    @PostConstruct
    public void postConstruct() {
        this.factory.setOverloadEnabled(true);
        this.baseHessianURL = this.jwsUtils.getApplicationURL() + HESSIAN_SERVLET_PATH;
        log.info("base hessian URL = " + this.baseHessianURL);
        try {
            this.rpcURL = new URL(this.jwsUtils.getApplicationURL() + RPC_SERVLET_PATH);
            log.info("base rpc URL = " + this.rpcURL);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T create(Class<T> clazz) throws IllegalArgumentException, MalformedURLException, NamingException {
        Validate.isTrue((boolean)clazz.isInterface());
        Object service = this.cache.get(clazz);
        if (service != null) {
            return (T)service;
        }
        if (this.config.getTransportLayer() == TransportLayer.HESSIAN) {
            service = this.createHessianProxy(clazz);
        } else if (this.config.getTransportLayer() == TransportLayer.RPC) {
            service = this.createRpcProxy(clazz);
        } else if (this.config.getTransportLayer() == TransportLayer.EJB) {
            service = this.createRemoteEJBProxy(clazz);
        } else {
            throw new IllegalStateException("Transport Layer: " + (Object)((Object)this.config.getTransportLayer()) + " Not implemeneted");
        }
        if (this.config.isTransportLogging()) {
            RemoteServiceLogger logger = (RemoteServiceLogger)this.removeServiceLoggerFactory.get();
            logger.setRemoteProxy(service);
            log.debug("Wrapping remote service client {} created in logger {} : ", service, (Object)logger);
            service = Proxy.newProxyInstance(service.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)logger);
            if (log.isTraceEnabled()) {
                for (Method m : service.getClass().getDeclaredMethods()) {
                    log.trace("RemoteServiceLogger proxy method: {}", (Object)m);
                }
            }
        }
        this.cache.put(clazz, service);
        return (T)service;
    }

    @Override
    public <T> T createHessianProxy(Class<T> type) throws MalformedURLException {
        String url = this.baseHessianURL + type.getName();
        log.debug("Creating service hessian client for class {}. URL: {}", (Object)type.getName(), (Object)url);
        Object service = this.factory.create(type, url);
        log.debug("Service hessian client created: " + service);
        return (T)service;
    }

    @Override
    public <T> T createRpcProxy(Class<T> type) throws MalformedURLException {
        RpcInvocationHandler handler = new RpcInvocationHandler(this.rpcURL, type, this.transport);
        Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{type}, (InvocationHandler)handler);
        log.debug("Rpc proxy created for {} handler {} proxy {} ", new Object[]{type, handler, proxy.getClass()});
        if (log.isTraceEnabled()) {
            for (Method m : proxy.getClass().getDeclaredMethods()) {
                log.trace("Rpc proxy method: {}", (Object)m);
            }
        }
        return (T)proxy;
    }

    @Override
    public <T> T createRemoteEJBProxy(Class<T> type) throws MalformedURLException, NamingException {
        String ejbModuleName = this.config.getEjbTransportModuleName();
        if (ejbModuleName == null) {
            log.debug("ejb module name not specified, will attempt application context path as module name");
            ejbModuleName = this.jwsUtils.getApplicationContextPath();
        }
        String s = "java:global/" + ejbModuleName + "/" + type.getSimpleName() + "Impl!" + type.getName();
        log.debug("Looking up {}", (Object)s);
        long ts = System.currentTimeMillis();
        Object ret = this.getRemoteEJBInitialContext().lookup(s);
        ts = System.currentTimeMillis() - ts;
        log.debug("Looking up {} took {}", (Object)s, (Object)ts);
        return (T)ret;
    }

    private synchronized InitialContext getRemoteEJBInitialContext() throws MalformedURLException, NamingException {
        if (this.remoteEJBInitialContext == null) {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("org.omg.CORBA.ORBInitialHost", this.jwsUtils.getApplicationHost());
            props.put("org.omg.CORBA.ORBInitialPort", "3700");
            this.remoteEJBInitialContext = new InitialContext(props);
        }
        return this.remoteEJBInitialContext;
    }
}

