/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.props;

import com.anahata.util.application.JWSUtils;
import com.anahata.util.props.StructuredPropertyEntry;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StructuredProperties {
    private static final Logger log = LoggerFactory.getLogger(StructuredProperties.class);
    private final Properties properties;
    private String prefix;

    public StructuredProperties(Properties props, String ... prefixes) {
        Validate.notNull((Object)props);
        this.prefix = StringUtils.join((Object[])prefixes, (String)".");
        this.prefix = StringUtils.isEmpty((CharSequence)this.prefix) ? "" : this.prefix + ".";
        this.properties = props;
    }

    public String getString(String key) {
        Validate.notNull((Object)key);
        String result = this.getProperty(key);
        Validate.isTrue((result != null ? 1 : 0) != 0, (String)"Property not found: %s", (Object[])new Object[]{key});
        return result;
    }

    public String getString(String key, String defaultValue) {
        Validate.notNull((Object)key);
        return this.getProperty(key, defaultValue);
    }

    public Integer getInteger(String key) {
        String value = this.getString(key);
        return Integer.valueOf(value);
    }

    public Integer getInteger(String key, int defaultValue) {
        String value = this.getString(key, null);
        return value != null ? Integer.valueOf(value) : defaultValue;
    }

    public Long getLong(String key) {
        String value = this.getString(key);
        return Long.valueOf(value);
    }

    public <T extends Enum<T>> T getEnum(Class<T> enumType, String key) {
        Validate.notNull(enumType);
        String value = this.getString(key);
        return Enum.valueOf(enumType, value);
    }

    public <T extends Enum<T>> T getEnum(Class<T> enumType, String key, T defaultValue) {
        Validate.notNull(enumType);
        String value = this.getString(key, null);
        return value != null ? Enum.valueOf(enumType, value) : defaultValue;
    }

    public Double getDouble(String key) {
        String value = this.getString(key);
        return Double.valueOf(value);
    }

    public Date getDate(String key, String format) {
        Validate.notNull((Object)format);
        String value = this.getString(key);
        try {
            return new SimpleDateFormat(format).parse(value);
        }
        catch (ParseException e) {
            throw new RuntimeException("Exception parsing date value '" + key + "' with format " + format);
        }
    }

    public boolean getBoolean(String key) {
        String value = this.getString(key);
        return Boolean.valueOf(value);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.getString(key, String.valueOf(defaultValue));
        return Boolean.valueOf(value);
    }

    public List<StructuredPropertyEntry<String>> getStringList(@NonNull String keyPrefix) {
        if (keyPrefix == null) {
            throw new NullPointerException("keyPrefix");
        }
        ArrayList<StructuredPropertyEntry<String>> values = new ArrayList<StructuredPropertyEntry<String>>();
        Enumeration<?> propNames = this.properties.propertyNames();
        String pre = this.prefix + keyPrefix + ".";
        int len = pre.length();
        while (propNames.hasMoreElements()) {
            String propName = (String)propNames.nextElement();
            if (!propName.startsWith(pre)) continue;
            StructuredPropertyEntry<String> entry = new StructuredPropertyEntry<String>(propName.substring(len), this.properties.getProperty(propName));
            values.add(entry);
        }
        return values;
    }

    private String getProperty(String key) {
        String effectiveKey = this.prefix + key;
        log.trace("Looking up effective key {}", (Object)effectiveKey);
        String value = this.properties.getProperty(effectiveKey);
        if (value == null) {
            log.trace("No value for property {} will try system property", (Object)effectiveKey);
            value = JWSUtils.getSystemProperty(effectiveKey);
        }
        return value;
    }

    private String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

