/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.logging.slf4j;

import org.slf4j.Logger;

public final class Slf4jUtils {
    public static void entering(Logger log, String sourceMethod, Object ... args) {
        if (!log.isTraceEnabled()) {
            return;
        }
        StringBuilder msg = new StringBuilder(sourceMethod);
        msg.append(": ENTRY");
        boolean first = true;
        for (Object obj : args) {
            if (first) {
                first = false;
                msg.append(" ");
            } else {
                msg.append(", ");
            }
            msg.append(obj);
        }
        log.trace(msg.toString());
    }

    public static void exiting(Logger log, String sourceMethod) {
        log.trace("{}: RETURN", (Object)sourceMethod);
    }

    public static void exiting(Logger log, String sourceMethod, Object result) {
        log.trace("{}: RETURN {}", (Object)sourceMethod, result);
    }

    private Slf4jUtils() {
    }
}

