/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.transport.hessian;

import com.anahata.util.transport.ServiceLookupUtils;
import com.caucho.hessian.io.SerializerFactory;
import com.caucho.hessian.server.HessianSkeleton;
import com.caucho.services.server.ServiceContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="DynamicHessianServlet", urlPatterns={"/hessian/*"})
public class DynamicHessianServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(DynamicHessianServlet.class);
    private static final long serialVersionUID = 1L;
    private HessianSkeleton homeSkeleton;
    private SerializerFactory serializerFactory;

    public void init() throws ServletException {
        super.init();
    }

    public String getServletInfo() {
        return "Dynamic Hessian Servlet";
    }

    public SerializerFactory getSerializerFactory() {
        if (this.serializerFactory == null) {
            this.serializerFactory = new SerializerFactory();
        }
        return this.serializerFactory;
    }

    public void setSendCollectionType(boolean sendType) {
        this.getSerializerFactory().setSendCollectionType(sendType);
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (!req.getMethod().equals("POST")) {
            res.sendError(500, "Hessian Requires POST");
            PrintWriter out = res.getWriter();
            res.setContentType("text/html");
            out.println("<h1>Hessian Requires POST</h1>");
            return;
        }
        String serviceId = req.getPathInfo().substring(1);
        String objectId = req.getParameter("id");
        if (objectId == null) {
            objectId = req.getParameter("ejbid");
        }
        Principal user = ((HttpServletRequest)request).getUserPrincipal();
        log.trace("serviceId={}, objectId={}, user={}", new Object[]{serviceId, objectId, user});
        ServiceContext.begin((ServletRequest)req, (ServletResponse)res, (String)serviceId, (String)objectId);
        try {
            ServletInputStream is = request.getInputStream();
            ServletOutputStream os = response.getOutputStream();
            response.setContentType("application/x-hessian");
            SerializerFactory serFactory = this.getSerializerFactory();
            Class<?> serviceInterface = this.loadClass(serviceId);
            Object service = ServiceLookupUtils.serviceLookup(serviceInterface);
            this.homeSkeleton = new HessianSkeleton(service, serviceInterface);
            this.homeSkeleton.invoke((InputStream)is, (OutputStream)os, serFactory);
        }
        catch (RuntimeException | ServletException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
        finally {
            ServiceContext.end();
        }
    }

    private Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            return Class.forName(className, false, loader);
        }
        return Class.forName(className);
    }
}

