/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.io;

import com.anahata.util.plaf.AnahataFilenameUtils;
import com.anahata.util.plaf.OSUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnahataFileUtils {
    private static final Logger log = LoggerFactory.getLogger(AnahataFileUtils.class);

    public static File createTempFile(String name) throws IOException {
        return AnahataFileUtils.createTempFile(name, null);
    }

    public static File createTempFile(String name, byte[] data) throws IOException {
        name = AnahataFilenameUtils.toValidFileName(name);
        File tempDir = FileUtils.getTempDirectory();
        tempDir = new File(tempDir, UUID.randomUUID().toString());
        tempDir.mkdirs();
        tempDir.deleteOnExit();
        File tempFile = new File(tempDir, name);
        tempFile.deleteOnExit();
        if (data != null) {
            FileUtils.writeByteArrayToFile((File)tempFile, (byte[])data);
        }
        return tempFile;
    }

    public static File createTempDir(String name, boolean unique, boolean deleteOnExit) {
        name = AnahataFilenameUtils.toValidFileName(name);
        File tempDir = FileUtils.getTempDirectory();
        if (unique) {
            tempDir = new File(tempDir, UUID.randomUUID().toString());
            if (deleteOnExit) {
                tempDir.deleteOnExit();
            }
        }
        tempDir = new File(tempDir, name);
        if (deleteOnExit) {
            tempDir.deleteOnExit();
        }
        tempDir.mkdirs();
        return tempDir;
    }

    public static File getApplicationDataDirectory(String appName) {
        File ret = OSUtils.isWindows() ? new File(System.getenv("APPDATA") + File.separator + appName) : (OSUtils.isMac() ? new File(OSUtils.getUserHome() + File.separator + "Library" + File.separator + "Application Support" + File.separator + appName) : new File(OSUtils.getUserHome(), "." + appName));
        ret.mkdirs();
        return ret;
    }

    public static File getAnahataUserDirectory() {
        File f = new File(OSUtils.getUserHome(), ".anahata");
        f.mkdirs();
        return f;
    }

    public static File getAnahataAppDataDirectory() {
        File f = AnahataFileUtils.getApplicationDataDirectory("anahata");
        f.mkdirs();
        return f;
    }

    public static byte[] convertToByteArray(String filePath) {
        File file = new File(filePath);
        byte[] b = new byte[(int)file.length()];
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            fileInputStream.read(b);
        }
        catch (FileNotFoundException e) {
            log.error("File Not Found {}", (Object)filePath);
        }
        catch (IOException e1) {
            log.error("Error in reading the file {}", (Object)filePath);
        }
        return b;
    }

    private AnahataFileUtils() {
    }
}

