/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.hessian;

import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class HessianUtils {
    public static byte[] serialize(Object data) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        HessianUtils.serialize(data, bos);
        return bos.toByteArray();
    }

    public static void serialize(Object data, OutputStream os) throws IOException {
        Hessian2Output out = new Hessian2Output(os);
        out.startMessage();
        out.writeObject(data);
        out.completeMessage();
        out.close();
    }

    public static Object deSerialize(byte[] data) throws IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        return HessianUtils.deSerialize(bis);
    }

    public static Object deSerialize(InputStream bis) throws IOException {
        Hessian2Input in = new Hessian2Input(bis);
        in.startMessage();
        Object ret = in.readObject();
        in.completeMessage();
        in.close();
        return ret;
    }

    public static long getDataSize(Object ... data) {
        if (data == null) {
            return 0L;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Hessian2Output out = new Hessian2Output((OutputStream)bos);
            out.startMessage();
            for (Object item : data) {
                out.writeObject(item);
            }
            out.completeMessage();
            out.close();
            return bos.toByteArray().length;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private HessianUtils() {
    }
}

