/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.search;

import com.anahata.util.search.AnahataSearchUtils;
import com.anahata.yam.model.search.SearchToken;
import com.anahata.yam.model.search.TokenType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class SearchTokens
implements Serializable {
    private final List<SearchToken> allTokens;
    private List<SearchToken> primalTokens;

    public SearchTokens(String queryString) {
        ArrayList<SearchToken> ret = new ArrayList<SearchToken>();
        List<String> base = AnahataSearchUtils.tokenize(queryString);
        for (String token : base) {
            if (token.contains(" ")) {
                int wordCount = StringUtils.countMatches((CharSequence)token, (CharSequence)" ") + 1;
                ret.add(new SearchToken(token, wordCount * 2, TokenType.QUOTED));
                continue;
            }
            ret.add(new SearchToken(token, 1, TokenType.BASIC));
        }
        int total = ret.size();
        for (int start = 0; start < total; ++start) {
            for (int length = 0; length < total - start; ++length) {
                int end = start + length;
                ArrayList<SearchToken> composite = new ArrayList<SearchToken>();
                for (int pos = start; pos <= end; ++pos) {
                    composite.add((SearchToken)ret.get(pos));
                }
                if (composite.size() <= 1) continue;
                ret.add(new SearchToken(composite));
            }
        }
        this.allTokens = Collections.unmodifiableList(ret);
    }

    public List<SearchToken> getPrimalTokens() {
        if (this.primalTokens == null) {
            ArrayList<SearchToken> list = new ArrayList<SearchToken>();
            for (SearchToken t : this.allTokens) {
                if (t.getType() == TokenType.COMPOSITE) continue;
                list.add(t);
            }
            this.primalTokens = Collections.unmodifiableList(list);
        }
        return this.primalTokens;
    }

    public List<SearchToken> getAllTokens() {
        return this.allTokens;
    }
}

