/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.yam.model.search;

import com.anahata.yam.model.search.SearchTokens;
import org.apache.commons.lang3.Validate;

public class FullTextCriteria {
    private String query;
    private boolean matchAllTokens;
    private boolean expandSearch = true;
    private SearchTokens searchTokens;

    public FullTextCriteria(String query, boolean matchAllTokens, boolean expandSearch) {
        this.setQuery(query);
        this.matchAllTokens = matchAllTokens;
        this.expandSearch = expandSearch;
    }

    public final void setQuery(String query) {
        Validate.notNull((Object)query, (String)"query can not be null", (Object[])new Object[0]);
        Validate.notNull((Object)query.trim().isEmpty(), (String)"query can not be empty", (Object[])new Object[0]);
        this.query = query;
        this.searchTokens = new SearchTokens(query);
    }

    public String getQuery() {
        return this.query;
    }

    public boolean isMatchAllTokens() {
        return this.matchAllTokens;
    }

    public boolean isExpandSearch() {
        return this.expandSearch;
    }

    public SearchTokens getSearchTokens() {
        return this.searchTokens;
    }

    public void setMatchAllTokens(boolean matchAllTokens) {
        this.matchAllTokens = matchAllTokens;
    }

    public void setExpandSearch(boolean expandSearch) {
        this.expandSearch = expandSearch;
    }
}

