/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.progress;

import com.anahata.util.progress.ProgressListener;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressOutputStream
extends OutputStream {
    private static final Logger log = LoggerFactory.getLogger(ProgressOutputStream.class);
    private final OutputStream outstream;
    private long bytesWritten = 0L;
    private double lastProgress = 0.0;
    private long totalLength;
    private final ProgressListener progressListener;

    public ProgressOutputStream(OutputStream outstream, long totalLength, ProgressListener pl) {
        this.outstream = outstream;
        this.progressListener = pl;
        this.totalLength = totalLength;
    }

    @Override
    public void write(int b) throws IOException {
        this.outstream.write(b);
        ++this.bytesWritten;
        this.updateProgress();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outstream.write(b);
        this.bytesWritten += (long)b.length;
        this.updateProgress();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outstream.write(b, off, len);
        this.bytesWritten += (long)len;
        this.updateProgress();
    }

    @Override
    public void flush() throws IOException {
        this.outstream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outstream.close();
    }

    private void updateProgress() {
        double progress = (double)(this.bytesWritten + 1L) / (double)(this.totalLength + 1L);
        double diff = progress - this.lastProgress;
        if (diff > 0.05) {
            log.trace("progress={}", (Object)progress);
            this.progressListener.progress(progress);
            this.lastProgress = progress;
        } else {
            log.trace("ignoring progress={}", (Object)progress);
        }
    }
}

