/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.plaf;

import com.anahata.util.formatting.Displayable;

public enum ByteUnit implements Displayable
{
    BYTE("Bytes"),
    KILOBYTE("KB"),
    MEGABYTE("MB"),
    GIGABYTE("GB"),
    TERABYTE("TB"),
    PETABYTE("PB");

    private String displayValue;

    public long getNumberOfBytes() {
        if (this == BYTE) {
            return 1L;
        }
        return (long)Math.pow(1024.0, this.ordinal());
    }

    public double to(double qty, ByteUnit toUnit) {
        double thisBytes = (double)this.getNumberOfBytes() * qty;
        double otherBytes = toUnit.getNumberOfBytes();
        return thisBytes / otherBytes;
    }

    public String toString() {
        return this.displayValue;
    }

    private ByteUnit(String displayValue) {
        this.displayValue = displayValue;
    }

    @Override
    public String getDisplayValue() {
        return this.displayValue;
    }
}

