/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.logging;

import com.anahata.util.logging.PerformanceInfo;
import com.anahata.util.logging.PerformanceWarning;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RemoteServiceWarning
extends PerformanceWarning
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(RemoteServiceWarning.class);
    private String className;
    private Method method;
    private Object[] args;
    private Object ret;
    private long time;
    private long argsSize;
    private long retSize;
    private Reason reason;

    public static RemoteServiceWarning newSlow(String className, Method method, Object[] args, long argsSize, Object ret, long retSize, long time) {
        RemoteServiceWarning warning = new RemoteServiceWarning();
        warning.className = className;
        warning.method = method;
        warning.args = args;
        warning.argsSize = argsSize;
        warning.ret = ret;
        warning.retSize = retSize;
        warning.time = time;
        warning.reason = Reason.SLOW;
        return warning;
    }

    public static RemoteServiceWarning newArgsLarge(String className, Method method, Object[] args, long argsSize) {
        RemoteServiceWarning warning = new RemoteServiceWarning();
        warning.className = className;
        warning.method = method;
        warning.args = args;
        warning.argsSize = argsSize;
        warning.reason = Reason.ARGS_LARGE;
        return warning;
    }

    public static RemoteServiceWarning newRetLarge(String className, Method method, Object ret, long retSize) {
        RemoteServiceWarning warning = new RemoteServiceWarning();
        warning.className = className;
        warning.method = method;
        warning.retSize = retSize;
        warning.reason = Reason.RET_LARGE;
        return warning;
    }

    public String getMethodName() {
        return this.method.getName();
    }

    @Override
    public PerformanceInfo toPerformanceInfo() {
        return new PerformanceInfo(this);
    }

    public String toString() {
        return "RemoteServiceWarning{className= " + this.className + ", method=" + this.method + ", args=" + ArrayUtils.toString((Object)this.args) + ", ret=" + this.ret + ", time=" + this.time + ", argsSize=" + this.argsSize + ", retSize=" + this.retSize + ", reason=" + (Object)((Object)this.reason) + '}';
    }

    public String getClassName() {
        return this.className;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public Object getRet() {
        return this.ret;
    }

    public long getTime() {
        return this.time;
    }

    public long getArgsSize() {
        return this.argsSize;
    }

    public long getRetSize() {
        return this.retSize;
    }

    public Reason getReason() {
        return this.reason;
    }

    private RemoteServiceWarning() {
    }

    public static enum Reason {
        SLOW,
        ARGS_LARGE,
        RET_LARGE;

    }
}

