/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.jpa;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Id;

public final class JPAAnnotationUtils {
    public static boolean isEntity(Class c) {
        return c.isAnnotationPresent(Entity.class);
    }

    @Deprecated
    public static Object getId(Object o) throws IntrospectionException, NoSuchFieldException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Field idField = JPAAnnotationUtils.getIdField(o.getClass());
        for (PropertyDescriptor pd : Introspector.getBeanInfo(o.getClass()).getPropertyDescriptors()) {
            if (pd.getReadMethod() == null || !pd.getName().equals(idField.getName())) continue;
            return pd.getReadMethod().invoke(o, (Object[])null);
        }
        throw new IllegalArgumentException("Could not find getter for field annotated with @" + Id.class.getName() + "");
    }

    public static Field getIdField(Class c) throws IntrospectionException, NoSuchFieldException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Field f : c.getDeclaredFields()) {
            if (!f.isAnnotationPresent(Id.class) && !f.isAnnotationPresent(EmbeddedId.class)) continue;
            return f;
        }
        throw new IllegalArgumentException("No field annotated as @Id or @EmbeddedId");
    }

    public static boolean isId(Class c, String propertyName) throws IntrospectionException, NoSuchFieldException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Field f = JPAAnnotationUtils.getIdField(c);
        return f.getName().equals(propertyName);
    }

    private JPAAnnotationUtils() {
    }
}

