/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.email;

import com.anahata.util.config.OutgoingEmailConfig;
import com.anahata.util.email.ByteArrayAttachment;
import com.anahata.util.email.Email;
import com.anahata.util.mime.MimeUtils;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.activation.DataSource;
import javax.enterprise.context.Dependent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.mail.DataSourceResolver;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.ImageHtmlEmail;
import org.apache.tika.io.IOUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class OutgoingEmailService {
    private static final Logger log = LoggerFactory.getLogger(OutgoingEmailService.class);
    private OutgoingEmailConfig config;

    public void sendEmail(Email email) throws EmailException {
        boolean overrideTo;
        ImageHtmlEmail htmlEmail;
        ImageHtmlEmailContents contents = new ImageHtmlEmailContents(email.getZippedContent());
        if (!contents.images.isEmpty()) {
            htmlEmail = new ImageHtmlEmail();
            htmlEmail.setDataSourceResolver((DataSourceResolver)contents);
        } else {
            htmlEmail = new HtmlEmail();
        }
        htmlEmail.setHtmlMsg(contents.getBody());
        htmlEmail.setCharset("UTF-8");
        htmlEmail.setHostName(this.getConfig().getHost());
        htmlEmail.setSmtpPort(this.getConfig().getPort());
        if (!StringUtils.isBlank((CharSequence)this.getConfig().getUser())) {
            htmlEmail.setAuthentication(this.getConfig().getUser(), this.getConfig().getPassword());
        }
        htmlEmail.setSSLOnConnect(this.getConfig().isSsl());
        String from = email.getFrom();
        if (from == null) {
            from = this.getConfig().getFrom();
        }
        htmlEmail.setFrom(from);
        String subject = email.getSubject();
        if (!StringUtils.isEmpty((CharSequence)this.getConfig().getSubject())) {
            subject = String.format(this.getConfig().getSubject(), subject);
        }
        htmlEmail.setSubject(subject);
        boolean bl = overrideTo = !StringUtils.isBlank((CharSequence)this.getConfig().getTo());
        if (overrideTo) {
            htmlEmail.addTo(this.getConfig().getTo());
        } else if (!email.getTo().isEmpty()) {
            htmlEmail.addTo(email.getTo().toArray(new String[0]));
        }
        if (!StringUtils.isEmpty((CharSequence)this.getConfig().getCc())) {
            htmlEmail.addCc(this.getConfig().getCc());
        }
        if (!overrideTo && !email.getCc().isEmpty()) {
            htmlEmail.addCc(email.getCc().toArray(new String[0]));
        }
        if (!StringUtils.isEmpty((CharSequence)this.getConfig().getBcc())) {
            htmlEmail.addBcc(this.getConfig().getBcc());
        }
        if (!overrideTo && !email.getBcc().isEmpty()) {
            htmlEmail.addBcc(email.getBcc().toArray(new String[0]));
        }
        if (this.getConfig().isBccSender()) {
            log.debug("adding sender as bcc= {}", (Object)from);
            htmlEmail.addBcc(from);
        } else {
            log.debug("NOT adding sender as bcc= {}", (Object)from);
        }
        log.debug("Sending email: from={}, to={}, cc={}, bcc={}, subject={}, attachments={}", new Object[]{htmlEmail.getFromAddress(), htmlEmail.getToAddresses(), htmlEmail.getCcAddresses(), htmlEmail.getBccAddresses(), htmlEmail.getSubject(), email.getAttachments().size()});
        for (ByteArrayAttachment attachment : email.getAttachments()) {
            log.debug("Attaching {} size = {} ", (Object)attachment.getName(), (Object)FileUtils.byteCountToDisplaySize((long)attachment.getData().length));
            htmlEmail.attach((DataSource)attachment, attachment.getName(), "");
        }
        htmlEmail.send();
        log.debug("Email sent: from={}, to={}, cc={}, bcc={}, subject={}, attachments={}", new Object[]{htmlEmail.getFromAddress(), htmlEmail.getToAddresses(), htmlEmail.getCcAddresses(), htmlEmail.getBccAddresses(), htmlEmail.getSubject(), email.getAttachments().size()});
    }

    public static void main(String[] args) throws Exception {
        Document d = Jsoup.parse((File)new File("/home/pablo/Desktop/test.hml"), (String)"UTF-16");
        Elements images = d.select("img[src^=data:image/png;base64,]");
        for (Element e : images) {
            String val = e.attr("src");
            String prefix = "data:image/png;base64,";
            val = val.substring(prefix.length());
        }
    }

    public OutgoingEmailService() {
    }

    @ConstructorProperties(value={"config"})
    public OutgoingEmailService(OutgoingEmailConfig config) {
        this.config = config;
    }

    public OutgoingEmailConfig getConfig() {
        return this.config;
    }

    protected void setConfig(OutgoingEmailConfig config) {
        this.config = config;
    }

    private static class ImageHtmlEmailContents
    implements DataSourceResolver {
        final String emeddedImagePreffix = "data:image/";
        final String emeddedImageSuffix = ";base64,";
        public String body;
        public Map<String, byte[]> images = new HashMap<String, byte[]>();

        public ImageHtmlEmailContents(byte[] zipFile) {
            try (ZipInputStream stream = new ZipInputStream(new ByteArrayInputStream(zipFile));){
                ZipEntry entry;
                while ((entry = stream.getNextEntry()) != null) {
                    byte[] content = IOUtils.toByteArray((InputStream)stream);
                    if (entry.getName().endsWith("html")) {
                        this.body = new String(content);
                        if (!this.body.contains("data:image/")) continue;
                        Document d = Jsoup.parse((String)this.body);
                        Elements elements = d.select("*");
                        int counter = 0;
                        for (Element e : elements) {
                            for (Attribute a : e.attributes()) {
                                String val = a.getValue();
                                if (!val.startsWith("data:image/")) continue;
                                String type = val.substring("data:image/".length(), val.indexOf(";base64,"));
                                val = val.substring(val.indexOf(";base64,") + ";base64,".length());
                                byte[] barr = Base64.getDecoder().decode(val);
                                String name = "image-" + counter++ + "." + type;
                                a.setValue(name);
                                this.images.put(name, barr);
                            }
                        }
                        this.body = d.toString();
                        continue;
                    }
                    this.images.put(entry.getName(), content);
                }
            }
            catch (Exception e) {
                log.error("exception inflating zip byte array", (Throwable)e);
                throw new RuntimeException("exception inflating zip byte array", e);
            }
        }

        public DataSource resolve(String resourceLocation) throws IOException {
            return this.resolve(resourceLocation, false);
        }

        public DataSource resolve(String resourceLocation, boolean isLenient) throws IOException {
            final String name = new File(resourceLocation).getName();
            final byte[] data = this.images.get(name);
            final String type = MimeUtils.getMimeType(data, name);
            return new DataSource(){

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(data);
                }

                public OutputStream getOutputStream() throws IOException {
                    throw new UnsupportedOperationException("Not supported.");
                }

                public String getContentType() {
                    return type;
                }

                public String getName() {
                    return name;
                }
            };
        }

        public String getEmeddedImagePreffix() {
            return this.emeddedImagePreffix;
        }

        public String getEmeddedImageSuffix() {
            return this.emeddedImageSuffix;
        }

        public String getBody() {
            return this.body;
        }

        public Map<String, byte[]> getImages() {
            return this.images;
        }
    }
}

