/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.logging;

import com.anahata.util.logging.FxThreadWarning;
import com.anahata.util.logging.RemoteServiceWarning;
import java.beans.ConstructorProperties;
import lombok.NonNull;

public class PerformanceInfo {
    private final String className;
    private final String methodName;
    private final RemoteServiceWarning.Reason reason;

    public PerformanceInfo(@NonNull RemoteServiceWarning warning) {
        if (warning == null) {
            throw new NullPointerException("warning");
        }
        this.className = warning.getClassName();
        this.methodName = warning.getMethodName();
        this.reason = warning.getReason();
    }

    public PerformanceInfo(@NonNull FxThreadWarning warning) {
        if (warning == null) {
            throw new NullPointerException("warning");
        }
        this.className = warning.getClass().getSimpleName();
        this.methodName = null;
        this.reason = RemoteServiceWarning.Reason.SLOW;
    }

    @ConstructorProperties(value={"className", "methodName", "reason"})
    public PerformanceInfo(String className, String methodName, RemoteServiceWarning.Reason reason) {
        this.className = className;
        this.methodName = methodName;
        this.reason = reason;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public RemoteServiceWarning.Reason getReason() {
        return this.reason;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PerformanceInfo)) {
            return false;
        }
        PerformanceInfo other = (PerformanceInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$methodName = this.getMethodName();
        String other$methodName = other.getMethodName();
        if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
            return false;
        }
        RemoteServiceWarning.Reason this$reason = this.getReason();
        RemoteServiceWarning.Reason other$reason = other.getReason();
        return !(this$reason == null ? other$reason != null : !((Object)((Object)this$reason)).equals((Object)other$reason));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PerformanceInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 0 : $className.hashCode());
        String $methodName = this.getMethodName();
        result = result * 59 + ($methodName == null ? 0 : $methodName.hashCode());
        RemoteServiceWarning.Reason $reason = this.getReason();
        result = result * 59 + ($reason == null ? 0 : ((Object)((Object)$reason)).hashCode());
        return result;
    }

    public String toString() {
        return "PerformanceInfo(className=" + this.getClassName() + ", methodName=" + this.getMethodName() + ", reason=" + (Object)((Object)this.getReason()) + ")";
    }
}

