/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class AnahataCollectionUtils {
    public static <T> List<List<T>> split(Collection<T> col, int maxSize) {
        ArrayList<T> list = new ArrayList<T>(col);
        if (col.size() <= maxSize) {
            return Collections.singletonList(list);
        }
        ArrayList<List<T>> ret = new ArrayList<List<T>>();
        int startIdx = 0;
        int endIdx = maxSize;
        while (startIdx < endIdx) {
            List chunk = list.subList(startIdx, endIdx);
            ret.add(chunk);
            startIdx = endIdx;
            endIdx = Math.min(list.size(), startIdx + maxSize);
        }
        return ret;
    }

    private AnahataCollectionUtils() {
    }
}

