/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.image;

import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.imgscalr.Scalr;

public class ScaleImage {
    public static byte[] scale(byte[] inFile, int maxWidth, int maxHeight, String format) throws IOException, InterruptedException, ExecutionException {
        return ScaleImage.scale(inFile, Scalr.Method.SPEED, Scalr.Mode.AUTOMATIC, maxWidth, maxHeight, format);
    }

    public static byte[] scale(byte[] inFile, Scalr.Method method, Scalr.Mode mode, int maxWidth, int maxHeight, String format) throws IOException, InterruptedException, ExecutionException {
        BufferedImage inImage = ImageIO.read(new ByteArrayInputStream(inFile));
        double scale = ScaleImage.calculateScale(inImage, maxWidth, maxHeight);
        if (scale < 1.0) {
            return ScaleImage.resize(inImage, method, mode, maxWidth, maxHeight, format);
        }
        return inFile;
    }

    public static byte[] scale(InputStream is, int maxWidth, int maxHeight, String format) throws IOException, InterruptedException, ExecutionException {
        byte[] barr = IOUtils.toByteArray((InputStream)is);
        return ScaleImage.scale(barr, maxWidth, maxHeight, format);
    }

    private static byte[] resize(BufferedImage inImage, Scalr.Method method, Scalr.Mode mode, int maxWidth, int maxHeight, String format) throws IOException, InterruptedException, ExecutionException {
        BufferedImage outImage = Scalr.resize((BufferedImage)inImage, (Scalr.Method)method, (Scalr.Mode)mode, (int)maxWidth, (int)maxHeight, (BufferedImageOp[])new BufferedImageOp[0]);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)outImage, format, baos);
        return baos.toByteArray();
    }

    private static double calculateScale(BufferedImage inImage, int maxWidth, int maxHeight) {
        int largestDimension = Math.max(maxWidth, maxHeight);
        if (inImage.getWidth(null) == -1 || inImage.getHeight(null) == -1) {
            throw new IllegalArgumentException("In file can not be read");
        }
        double scale = inImage.getWidth(null) > inImage.getHeight(null) ? (double)largestDimension / (double)inImage.getWidth(null) : (double)largestDimension / (double)inImage.getHeight(null);
        return scale;
    }

    private ScaleImage() {
    }
}

