/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.financial;

import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import org.apache.commons.lang3.Validate;

public final class CurrencyUtils {
    public static NumberFormat getCurrencyFormat(Currency currency) {
        Validate.notNull((Object)currency);
        for (Locale locale : NumberFormat.getAvailableLocales()) {
            NumberFormat numberFormat = NumberFormat.getCurrencyInstance(locale);
            if (!numberFormat.getCurrency().equals(currency)) continue;
            return numberFormat;
        }
        return null;
    }

    public static NumberFormat getCurrencyFormat(String currencyCode) {
        Validate.notNull((Object)currencyCode);
        return CurrencyUtils.getCurrencyFormat(Currency.getInstance(currencyCode));
    }

    private CurrencyUtils() {
    }
}

