/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.util.config.internal;

import com.anahata.util.config.internal.ApplicationPropertiesFactory;
import com.anahata.util.io.CompressionType;
import com.anahata.util.io.SerializationType;
import com.anahata.util.props.StructuredProperties;
import com.anahata.util.transport.RemoteServiceProxy;
import com.anahata.util.transport.TransportLayer;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class AnahataUtilConfig
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(AnahataUtilConfig.class);
    @Inject
    private ApplicationPropertiesFactory appProps;
    private String nonJwsApplicationUrl;
    private boolean autoLogin;
    private String autoLoginUser;
    private String autoLoginPassword;
    private TransportLayer transportLayer;
    private CompressionType rpcCompression;
    private SerializationType rpcSerialization;
    private int rpcSocketConnectTimout;
    private int rpcSocketReadTimout;
    private String ejbTransportModuleName;
    private boolean transportLogging;
    private int jmsPort;
    private Class<? extends RemoteServiceProxy> transportProxy;

    @PostConstruct
    void postConstruct() {
        StructuredProperties props = new StructuredProperties(this.appProps.getAppProperties(), "anahatautil");
        this.nonJwsApplicationUrl = props.getString("nonjws.application.url", null);
        this.autoLogin = props.getBoolean("security.autologin", false);
        this.autoLoginUser = props.getString("security.autologin.user", null);
        this.autoLoginPassword = props.getString("security.autologin.password", null);
        this.transportLayer = props.getEnum(TransportLayer.class, "transport.layer", TransportLayer.RPC);
        this.rpcCompression = props.getEnum(CompressionType.class, "transport.layer.rpc.compression", CompressionType.DEFLATE);
        this.rpcSerialization = props.getEnum(SerializationType.class, "transport.layer.rpc.serialization", SerializationType.JAVA);
        this.jmsPort = props.getInteger("transport.jms.port", 7676);
        this.ejbTransportModuleName = props.getString("transport.layer.ejb.module.name", null);
        this.transportLogging = props.getBoolean("transport.logging", false);
        this.rpcSocketConnectTimout = props.getInteger("transport.socket.connect.timout", 10000);
        this.rpcSocketReadTimout = props.getInteger("transport.socket.read.timout", 90000);
        try {
            this.transportProxy = props.getClass("transport.proxy", null);
        }
        catch (ClassNotFoundException ex) {
            log.warn("Classs {} Not found ", (Object)props.getString("transport.proxy"), (Object)ex);
        }
    }

    public String getNonJwsApplicationUrl() {
        return this.nonJwsApplicationUrl;
    }

    public boolean isAutoLogin() {
        return this.autoLogin;
    }

    public String getAutoLoginUser() {
        return this.autoLoginUser;
    }

    public String getAutoLoginPassword() {
        return this.autoLoginPassword;
    }

    public TransportLayer getTransportLayer() {
        return this.transportLayer;
    }

    public CompressionType getRpcCompression() {
        return this.rpcCompression;
    }

    public SerializationType getRpcSerialization() {
        return this.rpcSerialization;
    }

    public int getRpcSocketConnectTimout() {
        return this.rpcSocketConnectTimout;
    }

    public int getRpcSocketReadTimout() {
        return this.rpcSocketReadTimout;
    }

    public String getEjbTransportModuleName() {
        return this.ejbTransportModuleName;
    }

    public boolean isTransportLogging() {
        return this.transportLogging;
    }

    public int getJmsPort() {
        return this.jmsPort;
    }

    public Class<? extends RemoteServiceProxy> getTransportProxy() {
        return this.transportProxy;
    }
}

