/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.test;

import com.anahata.util.validation.ValidationUtils;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import org.apache.commons.lang3.Validate;
import org.eclipse.persistence.jpa.JpaEntityManager;
import org.eclipse.persistence.queries.AttributeGroup;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JpaTest {
    private static final Logger log = LoggerFactory.getLogger(JpaTest.class);
    protected static EntityManagerFactory emFactory;
    protected static EntityManager em;
    protected static EntityTransaction tx;

    @BeforeClass
    public static void setUpClassJpaTest() {
        String puName = System.getProperty("anahatatest.persistenceunit");
        Validate.validState((puName != null ? 1 : 0) != 0, (String)"System property anahatatest.persistenceunit is not present", (Object[])new Object[0]);
        emFactory = Persistence.createEntityManagerFactory((String)puName);
        em = emFactory.createEntityManager();
        tx = em.getTransaction();
    }

    @AfterClass
    public static void tearDownClassJpaTest() {
        if (em != null) {
            em.close();
        }
        em = null;
        tx = null;
    }

    @Before
    public void setUpJpaTest() {
        log.debug("setUpJpaTest");
        if (this.isTruncateSchemaBetweenTests()) {
            log.debug("Deleting all data in schema");
            this.begin();
            em.createNativeQuery("truncate schema public restart identity and commit no check").executeUpdate();
            em.createNativeQuery("create table if not exists sequence(seq_name varchar(50), seq_count decimal(38))").executeUpdate();
            em.createNativeQuery("insert into sequence(seq_name, seq_count) values ('SEQ_GEN', 0)").executeUpdate();
            this.commit();
        }
    }

    protected boolean isTruncateSchemaBetweenTests() {
        return true;
    }

    @After
    public void tearDownJpaTest() {
        if (tx.isActive()) {
            this.commit();
        }
        if (this.isTruncateSchemaBetweenTests()) {
            this.begin();
            em.createNativeQuery("truncate schema public restart identity and commit no check").executeUpdate();
            this.commit();
        }
        em.clear();
    }

    protected void begin() {
        tx.begin();
    }

    protected void commit() {
        try {
            tx.commit();
        }
        catch (Throwable t) {
            String message = ValidationUtils.getConstraintValidationDetails((Throwable)t);
            log.error(message, t);
            throw t;
        }
    }

    protected void rollback() {
        tx.rollback();
    }

    protected void flush() {
        try {
            em.flush();
        }
        catch (Throwable t) {
            String message = ValidationUtils.getConstraintValidationDetails((Throwable)t);
            log.error(message, t);
            throw t;
        }
    }

    protected void flommit() {
        try {
            em.flush();
            tx.commit();
        }
        catch (Throwable t) {
            String message = ValidationUtils.getConstraintValidationDetails((Throwable)t);
            log.error(message, t);
            throw t;
        }
    }

    protected void persist(Object entity) {
        try {
            em.persist(entity);
        }
        catch (Throwable t) {
            String message = ValidationUtils.getConstraintValidationDetails((Throwable)t);
            log.error(message, t);
            throw t;
        }
    }

    protected void perflush(Object entity) {
        try {
            em.persist(entity);
            em.flush();
        }
        catch (Throwable t) {
            String message = ValidationUtils.getConstraintValidationDetails((Throwable)t);
            log.error(message, t);
            throw t;
        }
    }

    protected void perflommit(Object entity) {
        try {
            em.persist(entity);
            em.flush();
            tx.commit();
        }
        catch (Throwable t) {
            String message = ValidationUtils.getConstraintValidationDetails((Throwable)t);
            log.error(message, t);
            throw t;
        }
    }

    protected void detach(Object entity) {
        em.detach(entity);
    }

    protected int update(String query) {
        return em.createQuery(query).executeUpdate();
    }

    protected <T> T merge(T entity) {
        try {
            return (T)em.merge(entity);
        }
        catch (Throwable t) {
            String message = ValidationUtils.getConstraintValidationDetails((Throwable)t);
            log.error(message, t);
            throw t;
        }
    }

    protected <T> T copy(T entity, AttributeGroup group) {
        JpaEntityManager jem = (JpaEntityManager)em.unwrap(JpaEntityManager.class);
        return (T)jem.copy(entity, group);
    }

    protected <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)em.find(entityClass, primaryKey);
    }
}

