/*
 * Decompiled with CFR 0.152.
 */
package com.anahata.test;

import java.util.Collection;
import org.apache.commons.lang3.Validate;
import org.junit.Assert;

public class AnahataAssert {
    public static <T extends Comparable<T>> void assertComparable(T expected, T actual) {
        Assert.assertTrue((String)("Assertion failed, expected <" + expected + "> but received <" + actual + ">"), (expected.compareTo(actual) == 0 ? 1 : 0) != 0);
    }

    public static void assertCollectionEquals(Collection expected, Collection actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null) {
            Assert.fail((String)("expected is null, actual is " + actual));
        }
        if (actual == null) {
            Assert.fail((String)("actual is null, expected is " + actual));
        }
        StringBuilder msg = new StringBuilder();
        for (Object obj : actual) {
            if (expected.contains(obj)) continue;
            if (msg.length() > 0) {
                msg.append(", ");
            }
            msg.append("expected does not contain actual object ");
            msg.append(obj);
        }
        for (Object obj : expected) {
            if (actual.contains(obj)) continue;
            if (msg.length() > 0) {
                msg.append(", ");
            }
            msg.append("actual does not contain expected object ");
            msg.append(obj);
        }
        if (msg.length() > 0) {
            Assert.fail((String)msg.toString());
        }
    }

    public static <T> void assertCollectionContains(T expected, Collection<T> collection) {
        Validate.notNull(expected);
        Validate.notNull(collection);
        if (!collection.contains(expected)) {
            Assert.fail((String)("The given collection does not contain expected with value " + expected));
        }
    }

    public static <T> void assertCollectionDoesNotContain(T expected, Collection<T> collection) {
        Validate.notNull(expected);
        Validate.notNull(collection);
        if (collection.contains(expected)) {
            Assert.fail((String)("The given collection contains value " + expected));
        }
    }

    private AnahataAssert() {
    }
}

